/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static Player getPlayerOfFakePlayer(@NotNull Player player, @NotNull Level world) {
        Player tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.getPlayerByUUID(player.getUUID())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static Entity getPlayerByUUID(@NotNull Level world, @NotNull UUID id) {
        return world.getPlayerByUUID(id);
    }

    public static List<Entity> getEntitiesFromID(@NotNull Level world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((Level)world).getEntity(arg_0)).collect(Collectors.toList());
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = Mth.wrapDegrees((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public static boolean checkForFreeSpace(@NotNull Level world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.above(i)) && !world.getBlockState(groundPosition.above(i)).is(BlockTags.LEAVES)) continue;
            return false;
        }
        return BlockUtils.isAnySolid((BlockState)world.getBlockState(groundPosition));
    }

    public static boolean solidOrLiquid(@NotNull Level world, @NotNull BlockPos blockPos) {
        BlockState state = world.getBlockState(blockPos);
        return state.liquid() || BlockUtils.isAnySolid((BlockState)state);
    }

    @Nullable
    public static BlockPos getSpawnPoint(Level world, BlockPos nearPoint) {
        return BlockPosUtil.findAround(world, nearPoint, 5, 5, (w, p) -> {
            if (EntityUtils.checkValidSpawn(w, p, 2)) {
                for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
                    if (!EntityUtils.checkValidSpawn(w, p.relative(dir, 1), 2)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static boolean checkValidSpawn(@NotNull BlockGetter world, BlockPos pos, int height) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.getBlockState(pos.above(dy));
            if (state.is(ModTags.validSpawn) || !PathfindingUtils.isLiquid(state) && !ShapeUtil.hasCollision(world, pos.above(dy), state)) continue;
            return false;
        }
        return SurfaceType.getSurfaceType(world, world.getBlockState(pos.below()), pos.below()) == SurfaceType.WALKABLE || SurfaceType.getSurfaceType(world, world.getBlockState(pos.below(2)), pos.below(2)) == SurfaceType.WALKABLE;
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, int x, int y, int z, double speedFactor) {
        if (living instanceof AbstractFastMinecoloniesEntity) {
            AbstractFastMinecoloniesEntity entity = (AbstractFastMinecoloniesEntity)living;
            return EntityNavigationUtils.walkToPos(entity, new BlockPos(x, y, z), 4, true, speedFactor);
        }
        return true;
    }

    public static boolean isLivingAtSiteWithMove(@NotNull LivingEntity entity, int x, int y, int z, int range) {
        if (x == 0 && y == 0 && z == 0) {
            return false;
        }
        if (!EntityUtils.isLivingAtSite(entity, x, y, z, 512)) {
            BlockPos spawnPoint = EntityUtils.getSpawnPoint(entity.getCommandSenderWorld(), new BlockPos(x, y, z));
            if (spawnPoint == null) {
                spawnPoint = new BlockPos(x, y, z);
            }
            entity.moveTo((double)spawnPoint.getX() + 0.5, (double)spawnPoint.getY(), (double)spawnPoint.getZ() + 0.5, entity.getYRot(), entity.getXRot());
            return true;
        }
        return EntityUtils.isLivingAtSite(entity, x, y, z, range);
    }

    public static boolean isLivingAtSite(@NotNull LivingEntity entityLiving, int x, int y, int z, int range) {
        BlockPos pos = BlockPos.containing((double)entityLiving.getX(), (double)entityLiving.getY(), (double)entityLiving.getZ());
        return (double)BlockPosUtil.distSqr(pos, x, y, z) < MathUtils.square(range);
    }

    public static boolean isFlying(LivingEntity target) {
        return target != null && (target.hasImpulse || !target.onGround()) && target.fallDistance <= 0.1f && target.level().isEmptyBlock(target.blockPosition().below(2));
    }

    public static Predicate<Entity> pushableBy() {
        return EntitySelector.NO_SPECTATORS.and(localEntity -> {
            if (!localEntity.isPushable()) {
                return false;
            }
            return !localEntity.level().isClientSide || localEntity instanceof Player && ((Player)localEntity).isLocalPlayer();
        });
    }
}

