/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks.huts;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.network.messages.server.GetColonyInfoMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockHutTownHall
extends AbstractBlockHut<BlockHutTownHall> {
    private int breakProgressOnTownHall = 0;
    private long lastTownHallBreakingTick = 0L;
    private boolean validTownHallBreak = false;
    public static long timeout = 0L;

    public BlockHutTownHall() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(10.0f, Float.POSITIVE_INFINITY));
    }

    @Override
    public float getDestroyProgress(BlockState state, @NotNull Player player, @NotNull BlockGetter blockReader, @NotNull BlockPos pos) {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get()).booleanValue() && player.level() instanceof ServerLevel) {
            IBuilding building = IColonyManager.getInstance().getBuilding(player.level(), pos);
            if (building != null && building.getColony().isCoordInColony(player.level(), pos) && building.getColony().getPermissions().getRank(player).isHostile()) {
                double localProgress = this.breakProgressOnTownHall;
                double hardness = (double)state.getDestroySpeed((BlockGetter)player.level(), pos) * 20.0 * 1.5;
                if (localProgress >= hardness / 10.0 * 9.0 && localProgress <= hardness / 10.0 * 9.0 + 1.0) {
                    MessageUtils.format("com.minecolonies.coremod.pvp.townhall.broke", player.getName(), 90).sendTo(building.getColony()).forAllPlayers();
                }
                if (localProgress >= hardness / 4.0 * 3.0 && localProgress <= hardness / 4.0 * 3.0 + 1.0) {
                    MessageUtils.format("com.minecolonies.coremod.pvp.townhall.broke", player.getName(), 75).sendTo(building.getColony()).forAllPlayers();
                } else if (localProgress >= hardness / 2.0 && localProgress <= hardness / 2.0 + 1.0) {
                    MessageUtils.format("com.minecolonies.coremod.pvp.townhall.broke", player.getName(), 50).sendTo(building.getColony()).forAllPlayers();
                } else if (localProgress >= hardness / 4.0 && localProgress <= hardness / 4.0 + 1.0) {
                    MessageUtils.format("com.minecolonies.coremod.pvp.townhall.broke", player.getName(), 25).sendTo(building.getColony()).forAllPlayers();
                }
                if (localProgress >= hardness - 1.0) {
                    this.validTownHallBreak = true;
                }
                if (player.level().getGameTime() - this.lastTownHallBreakingTick < 10L) {
                    ++this.breakProgressOnTownHall;
                } else {
                    MessageUtils.format("com.minecolonies.coremod.pvp.townhall.broke", player.getName(), 100).sendTo(building.getColony()).forAllPlayers();
                    this.breakProgressOnTownHall = 0;
                    this.validTownHallBreak = false;
                }
                this.lastTownHallBreakingTick = player.level().getGameTime();
            } else {
                this.validTownHallBreak = true;
            }
        } else if (!((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get()).booleanValue()) {
            this.validTownHallBreak = true;
        }
        float def = super.getDestroyProgress(state, player, (BlockGetter)player.level(), pos);
        return (Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get() != false ? def / 12.0f : def;
    }

    @Override
    public List<MutableComponent> getRequirements(ClientLevel level, BlockPos pos, LocalPlayer player) {
        ArrayList<MutableComponent> requirements = new ArrayList<MutableComponent>();
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.getInventory()), this) == -1) {
            requirements.add(Component.translatableEscape((String)"com.minecolonies.coremod.hut.cost", (Object[])new Object[]{Component.translatableEscape((String)("block.minecolonies." + this.getHutName()), (Object[])new Object[0])}).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        return requirements;
    }

    public boolean getValidBreak() {
        return this.validTownHallBreak;
    }

    @Override
    @NotNull
    public String getHutName() {
        return "blockhuttownhall";
    }

    @Override
    public BuildingEntry getBuildingEntry() {
        return (BuildingEntry)ModBuildings.townHall.get();
    }

    @Override
    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.isClientSide) {
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.dimension(), pos);
            if (building != null && building.getColony() != null && building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                building.openGui(player.isShiftKeyDown());
            } else if (System.currentTimeMillis() > timeout) {
                new GetColonyInfoMessage(pos).sendToServer();
                timeout = System.currentTimeMillis() + 1000L;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public boolean canPlaceAt(BlockPos pos, Player player) {
        IColony colony = IColonyManager.getInstance().getIColony(player.level(), pos);
        if (colony.hasTownHall()) {
            ITownHall townHall = colony.getBuildingManager().getTownHall();
            if (colony.getWorld() != null && !colony.getWorld().isClientSide) {
                MessageUtils.format("tile.blockhuttownhall.messageplacedalready", townHall.getPosition().toShortString()).sendTo(player);
            }
            return false;
        }
        return true;
    }
}

