/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.interfaces.IInvisibleBlueprintAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.IOPool;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WindowBuildingBrowser
extends AbstractWindowSkeleton {
    private static final int WORKER_THREADS = 4;
    private static final int COLOR_NORMAL = ChatFormatting.BLACK.getColor();
    private static final int COLOR_CHILD = ChatFormatting.DARK_GREEN.getColor();
    private static final int COLOR_INVISIBLE = ChatFormatting.DARK_BLUE.getColor();
    private static final int COLOR_INVISIBLE_CHILD = ChatFormatting.BLUE.getColor();
    private static final Map<Block, List<BuildingInfo>> buildingCache = new HashMap<Block, List<BuildingInfo>>();
    private final Block block;
    private List<BuildingInfo> buildings;
    private Future<List<BuildingInfo>> futureBuildings;
    private AtomicInteger currentProgress = new AtomicInteger();
    private int totalProgress;

    public WindowBuildingBrowser(@NotNull Block block) {
        super(new ResourceLocation("minecolonies", "gui/windowbrowsebuilding.xml"));
        this.block = block;
    }

    public static void clearCache() {
        buildingCache.clear();
    }

    public void onOpened() {
        super.onOpened();
        Block block = this.block;
        if (block instanceof AbstractBlockHut) {
            AbstractBlockHut hutBlock = (AbstractBlockHut)block;
            ((Text)this.findPaneOfTypeByID("constructionName", Text.class)).setText(hutBlock.getBlueprintDisplayName());
        } else {
            ((Text)this.findPaneOfTypeByID("constructionName", Text.class)).setText(this.block.getName());
        }
        this.currentProgress.set(0);
        this.totalProgress = 100;
        this.futureBuildings = IOPool.submit(this::discoverBuildings);
    }

    public void onClosed() {
        super.onClosed();
        if (this.futureBuildings != null) {
            this.futureBuildings.cancel(false);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.futureBuildings != null && this.futureBuildings.isDone()) {
            try {
                this.buildings = this.futureBuildings.get();
                this.displayBuildings();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            this.futureBuildings = null;
        } else if (this.futureBuildings != null) {
            Image progress = (Image)this.findPaneOfTypeByID("progress", Image.class);
            int fullWidth = ((Text)this.findPaneOfTypeByID("loading", Text.class)).getWidth();
            double progressValue = this.currentProgress.doubleValue() / (double)this.totalProgress;
            int progressWidth = (int)Math.round(progressValue * (double)fullWidth);
            progress.setSize(progressWidth, progress.getHeight());
        }
    }

    private void displayBuildings() {
        ((Text)this.findPaneOfTypeByID("loading", Text.class)).hide();
        ((Image)this.findPaneOfTypeByID("progress", Image.class)).hide();
        final List<BuildingInfo> visibleBuildings = this.mc.player.isCreative() ? this.buildings : this.buildings.stream().filter(b -> !b.isInvisible()).toList();
        ScrollingList buildingList = (ScrollingList)this.findPaneOfTypeByID("buildings", ScrollingList.class);
        buildingList.enable();
        buildingList.show();
        buildingList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return visibleBuildings.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                BuildingInfo building = (BuildingInfo)visibleBuildings.get(index);
                Text packLabel = (Text)rowPane.findPaneOfTypeByID("packName", Text.class);
                Text nameLabel = (Text)rowPane.findPaneOfTypeByID("buildingName", Text.class);
                Text sizeLabel = (Text)rowPane.findPaneOfTypeByID("buildingSize", Text.class);
                Text levelLabel = (Text)rowPane.findPaneOfTypeByID("buildingLevel", Text.class);
                packLabel.setText(Component.literal((String)building.pack().getName()));
                nameLabel.setText(Component.literal((String)building.path()));
                nameLabel.setColors(building.isParent() ? (building.isInvisible() ? COLOR_INVISIBLE_CHILD : COLOR_CHILD) : (building.isInvisible() ? COLOR_INVISIBLE : COLOR_NORMAL));
                sizeLabel.setText(Component.literal((String)String.format("%d x %d x %d", building.size().getX(), building.size().getY(), building.size().getZ())));
                if (building.levels().isEmpty()) {
                    levelLabel.hide();
                } else {
                    levelLabel.show();
                    levelLabel.setText(WindowBuildingBrowser.this.formatLevels(building.levels()));
                }
            }
        });
    }

    @NotNull
    private Component formatLevels(@NotNull Set<Integer> levels) {
        ArrayList<Integer> list = new ArrayList<Integer>(levels);
        if (list.size() == 1) {
            return Component.literal((String)Integer.toString((Integer)list.get(0)));
        }
        int minLevel = (Integer)list.get(0);
        int maxLevel = (Integer)list.get(list.size() - 1);
        if (list.size() == maxLevel - minLevel + 1) {
            return Component.translatableEscape((String)"%s-%s", (Object[])new Object[]{Integer.toString(minLevel), Integer.toString(maxLevel)});
        }
        return Component.literal((String)String.join((CharSequence)",", list.stream().map(i -> Integer.toString(i)).toList()));
    }

    @NotNull
    private List<BuildingInfo> discoverBuildings() {
        List<BuildingInfo> cached = buildingCache.get(this.block);
        if (cached != null) {
            return cached;
        }
        this.rebuildCache();
        return buildingCache.getOrDefault(this.block, new ArrayList());
    }

    private void rebuildCache() {
        if (!StructurePacks.waitUntilFinishedLoading()) {
            return;
        }
        List<Block> browsableBlocks = WindowBuildingBrowser.findBrowsableBlocks();
        ExecutorService packPool = Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable, "Minecolonies Building Browser Worker");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((thread1, throwable) -> Log.getLogger().error("Minecolonies Building Browser errored! ", throwable));
            return thread;
        });
        this.totalProgress = StructurePacks.getPackMetas().size();
        Map<StructurePackMeta, Future> packFutures = StructurePacks.getPackMetas().stream().collect(Collectors.toMap(pack -> pack, pack -> packPool.submit(() -> this.discoverBuildings((StructurePackMeta)pack, browsableBlocks))));
        while (!this.futureBuildings.isCancelled() && packFutures.values().stream().anyMatch(f -> !f.isDone())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                packPool.shutdown();
                return;
            }
        }
        packPool.shutdown();
        if (this.futureBuildings.isCancelled()) {
            return;
        }
        buildingCache.clear();
        for (Future futureBuildings : packFutures.entrySet().stream().sorted(Comparator.comparing(entry -> ((StructurePackMeta)entry.getKey()).getName())).map(Map.Entry::getValue).toList()) {
            try {
                for (Map.Entry entry2 : ((Map)futureBuildings.get()).entrySet()) {
                    buildingCache.merge((Block)entry2.getKey(), (List)entry2.getValue(), (prev, next) -> ImmutableList.builder().addAll((Iterable)prev).addAll((Iterable)next).build());
                }
            }
            catch (InterruptedException | ExecutionException exception) {
            }
        }
    }

    @NotNull
    private Map<Block, List<BuildingInfo>> discoverBuildings(@NotNull StructurePackMeta pack, @NotNull List<Block> browsableBlocks) {
        HashMap<Block, List<BuildingInfo>> buildings = new HashMap<Block, List<BuildingInfo>>();
        try (Stream<Path> paths = Files.walk(pack.getPath(), new FileVisitOption[0]);){
            paths.forEach(file -> {
                Blueprint blueprint;
                if (this.futureBuildings.isCancelled()) {
                    return;
                }
                if (!Files.isDirectory(file, new LinkOption[0]) && file.toString().endsWith(".blueprint") && (blueprint = StructurePacks.getBlueprint((String)pack.getName(), (Path)file, (boolean)true, (HolderLookup.Provider)this.mc.level.registryAccess())) != null) {
                    BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
                    for (Block block : browsableBlocks) {
                        this.classifyBlueprint(pack, buildings, blueprint, anchor, block);
                    }
                }
            });
        }
        catch (IOException e) {
            Log.getLogger().error("Error loading blueprints for {}: ", (Object)pack.getName(), (Object)e);
        }
        buildings.replaceAll((k, v) -> BuildingInfo.flattenLevels(v));
        this.currentProgress.getAndIncrement();
        return buildings;
    }

    @NotNull
    private static List<Block> findBrowsableBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof IBuildingBrowsableBlock).toList();
    }

    private void classifyBlueprint(@NotNull StructurePackMeta pack, @NotNull Map<Block, List<BuildingInfo>> buildings, @NotNull Blueprint blueprint, @NotNull BlockState anchor, @NotNull Block block) {
        if (anchor.is(block)) {
            buildings.computeIfAbsent(block, k -> new ArrayList()).add(BuildingInfo.create(pack, blueprint, false));
        } else if (Arrays.stream(blueprint.getPalette()).anyMatch(p -> p.is(block))) {
            buildings.computeIfAbsent(block, k -> new ArrayList()).add(BuildingInfo.create(pack, blueprint, true));
        }
    }

    private record BuildingInfo(StructurePackMeta pack, String path, Set<Integer> levels, BlockPos size, boolean isParent, boolean isInvisible) {
        @NotNull
        public static BuildingInfo create(@NotNull StructurePackMeta pack, @NotNull Blueprint blueprint, boolean isParent) {
            Object path = pack.getSubPath(blueprint.getFilePath()).replace('\\', '/');
            String name = blueprint.getFileName().replace(".blueprint", "");
            TreeSet<Integer> levels = new TreeSet<Integer>();
            if (name.length() > 0 && Character.isDigit(name.charAt(name.length() - 1))) {
                levels.add(Integer.parseInt(name.substring(name.length() - 1)));
                name = name.substring(0, name.length() - 1);
            }
            path = (String)path + "/" + name;
            BlockPos size = new BlockPos(blueprint.getSizeX(), (int)blueprint.getSizeY(), blueprint.getSizeZ());
            return new BuildingInfo(pack, (String)path, levels, size, isParent, BuildingInfo.isInvisible(blueprint));
        }

        public static List<BuildingInfo> flattenLevels(@NotNull List<BuildingInfo> input) {
            return input.stream().collect(Collectors.groupingBy(BuildingInfo::path)).values().stream().map(BuildingInfo::getFlattened).toList();
        }

        private static BuildingInfo getFlattened(@NotNull List<BuildingInfo> input) {
            BuildingInfo first = input.get(0);
            Set levels = input.stream().flatMap(info -> info.levels.stream()).collect(Collectors.toCollection(TreeSet::new));
            BlockPos size = input.stream().map(BuildingInfo::size).max(Comparator.naturalOrder()).get();
            return new BuildingInfo(first.pack, first.path, levels, size, first.isParent, first.isInvisible);
        }

        private static boolean isInvisible(@NotNull Blueprint blueprint) {
            Map tagMap;
            List anchorTags;
            IInvisibleBlueprintAnchorBlock invis;
            BlockInfo anchor = (BlockInfo)blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset());
            Block block = anchor.getState().getBlock();
            if (block instanceof IInvisibleBlueprintAnchorBlock && !(invis = (IInvisibleBlueprintAnchorBlock)block).isVisible(anchor.getTileEntityData())) {
                return true;
            }
            assert (!anchor.hasTileEntityData() || anchor.getTileEntityData() != null);
            return anchor.hasTileEntityData() && anchor.getTileEntityData().contains("blueprintDataProvider") && (anchorTags = (tagMap = IBlueprintDataProviderBE.readTagPosMapFrom((CompoundTag)anchor.getTileEntityData().getCompound("blueprintDataProvider"))).computeIfAbsent(BlockPos.ZERO, k -> new ArrayList())).contains("invisible");
        }
    }
}

