/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.client.gui.AbstractWindowRequestTree;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.postbox.PostBoxRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowPostBoxMain
extends AbstractWindowRequestTree {
    private static final String TAG_BUTTON_DELIVER_AVAILABLE = "deliverAvailable";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList stackList;
    private final AbstractBuildingView buildingView;
    private String filter = "";
    private boolean deliverAvailable;
    private int tick;

    public WindowPostBoxMain(AbstractBuildingView buildingView) {
        super(buildingView.getColony(), buildingView.getID(), new ResourceLocation("minecolonies", "gui/windowpostboxrequest.xml"));
        this.buildingView = buildingView;
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("request", this::requestClicked);
        this.registerButton(TAG_BUTTON_DELIVER_AVAILABLE, this::deliverPartialClicked);
        ((TextField)this.window.findPaneOfTypeByID("name", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
        WindowPostBoxMain.registerNavButtons(this, buildingView);
    }

    private static void registerNavButtons(AbstractWindowSkeleton window, AbstractBuildingView buildingView) {
        window.registerButton("requestTab", () -> new WindowPostBoxMain(buildingView).open());
        window.registerButton("requestIcon", () -> new WindowPostBoxMain(buildingView).open());
        PaneBuilders.tooltipBuilder().hoverPane(window.findPaneByID("requestIcon")).build().setText(Component.translatable((String)"com.minecolonies.coremod.gui.citizen.requests"));
        window.registerButton("minimumStockTab", () -> WindowPostBoxMain.openMinimumStockWindow(buildingView));
        window.registerButton("minimumStockIcon", () -> WindowPostBoxMain.openMinimumStockWindow(buildingView));
        PaneBuilders.tooltipBuilder().hoverPane(window.findPaneByID("minimumStockIcon")).build().setText(Component.translatable((String)"com.minecolonies.coremod.gui.warehouse.stock"));
    }

    private static void openMinimumStockWindow(AbstractBuildingView buildingView) {
        BOWindow min_stock_window = buildingView.getModuleView(BuildingModules.MIN_STOCK_POSTBOX).getWindow();
        WindowPostBoxMain.registerNavButtons((AbstractWindowSkeleton)min_stock_window, buildingView);
        min_stock_window.open();
    }

    private void inventoryClicked() {
        new OpenInventoryMessage(this.buildingView).sendToServer();
    }

    private void requestClicked(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStack stack = this.allItems.get(row);
        int qty = stack.getMaxStackSize();
        for (Pane child : button.getParent().getChildren()) {
            if (!child.getID().equals("qty")) continue;
            try {
                qty = Integer.parseInt(((TextField)child).getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        new PostBoxRequestMessage(this.buildingView, stack.copy(), qty, this.deliverAvailable).sendToServer();
    }

    private void deliverPartialClicked(@NotNull Button button) {
        if (button.getTextAsString().equals(RED_X)) {
            button.setText(Component.literal((String)APPROVE));
            this.deliverAvailable = true;
        } else {
            button.setText(Component.literal((String)RED_X));
            this.deliverAvailable = false;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_DELIVER_AVAILABLE, Button.class)).setText(Component.literal((String)RED_X));
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getItem() instanceof EnchantedBookItem && stack.getTagEnchantments().entrySet().stream().anyMatch(f -> ((Holder)f.getKey()).getRegisteredName().contains(this.filter.toLowerCase(Locale.US)));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.getHoverName().getString(), (CharSequence)this.filter)));
        this.updateResourceList();
    }

    private Collection<? extends ItemStack> getBlockList(Predicate<ItemStack> filterPredicate) {
        Set<ItemStack> allItems = ItemStackUtils.allItemsPlusInventory((Player)Minecraft.getInstance().player);
        if (this.filter.isEmpty()) {
            return allItems;
        }
        return allItems.stream().filter(filterPredicate).collect(Collectors.toList());
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.getHoverName());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }
}

