/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.network.messages.server.colony.HireSpiesMessage;
import com.minecolonies.core.tileentities.TileEntityRack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class WindowsBarracksSpies
extends BOWindow
implements ButtonHandler {
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_HIRE = "hireSpies";
    private static final String SPIES_BUTTON_ICON = "hireSpiesIcon";
    private static final String GOLD_COST_LABEL = "amount";
    private static final String TEXT_ID = "text";
    private static final int GOLD_COST = 5;
    private final IBuildingView buildingView;

    public WindowsBarracksSpies(IBuildingView buildingView, BlockPos buildingPos) {
        super(new ResourceLocation("minecolonies", "gui/windowbarracksspies.xml"));
        this.buildingView = buildingView;
        ((ItemIcon)this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class)).setItem(Items.GOLD_INGOT.getDefaultInstance());
        ((Text)this.findPaneOfTypeByID(GOLD_COST_LABEL, Text.class)).setText(Component.literal((String)"x5"));
        IItemHandlerModifiable rackInv = ((TileEntityRack)buildingView.getColony().getWorld().getBlockEntity(buildingPos)).getInventory();
        InvWrapper playerInv = new InvWrapper((Container)Minecraft.getInstance().player.getInventory());
        int goldCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.GOLD_INGOT);
        if (!buildingView.getColony().isRaiding() || (goldCount += InventoryUtils.getItemCountInItemHandler((IItemHandler)rackInv, Items.GOLD_INGOT)) < 5 || buildingView.getColony().areSpiesEnabled()) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class)).disable();
        }
        ((Text)this.findPaneOfTypeByID(TEXT_ID, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.barracks.spies.desc", (Object[])new Object[0]));
    }

    public void onButtonClicked(Button button) {
        switch (button.getID()) {
            case "cancel": {
                this.close();
                break;
            }
            case "hireSpies": {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class)).disable();
                new HireSpiesMessage(this.buildingView.getColony()).sendToServer();
                this.close();
            }
        }
    }
}

