/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityScarecrow;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowSelectRes;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.items.ItemCrop;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldPlotResizeMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldUpdateSeedMessage;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.CropBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WindowField
extends AbstractWindowSkeleton {
    private static final String NOT_IN_COLONY_TEXT_ID = "not-in-colony";
    private static final String DIRECTIONAL_BUTTON_ID_PREFIX = "dir-resize-";
    private static final String DIRECTIONAL_BUTTON_CENTER_ICON_ID = "dir-center";
    private static final String SELECT_SEED_BUTTON_ID = "select-seed";
    private static final String CURRENT_SEED_TEXT_ID = "current-seed";
    private static final String CURRENT_FARMER_TEXT_ID = "current-farmer";
    @NotNull
    private final AbstractTileEntityScarecrow tileEntityScarecrow;
    @Nullable
    private FarmField farmField;

    public WindowField(@NotNull AbstractTileEntityScarecrow tileEntityScarecrow) {
        super(new ResourceLocation("minecolonies", "gui/windowfield.xml"));
        this.tileEntityScarecrow = tileEntityScarecrow;
        this.registerButton(SELECT_SEED_BUTTON_ID, this::selectSeed);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            this.registerButton(DIRECTIONAL_BUTTON_ID_PREFIX + dir.getName(), this::onDirectionalButtonClick);
        }
        this.updateAll();
    }

    private void selectSeed() {
        new WindowSelectRes(this, stack -> {
            ItemCrop itemCrop;
            Item patt1$temp;
            BlockItem item;
            Item patt0$temp;
            return stack.is(Tags.Items.SEEDS) || (patt0$temp = stack.getItem()) instanceof BlockItem && (item = (BlockItem)patt0$temp).getBlock() instanceof CropBlock || (patt1$temp = stack.getItem()) instanceof ItemCrop && (itemCrop = (ItemCrop)patt1$temp).canBePlantedIn((Holder<Biome>)Minecraft.getInstance().level.getBiome(this.tileEntityScarecrow.getBlockPos()));
        }, (stack, qty) -> this.setSeed((ItemStack)stack), false).open();
    }

    private void onDirectionalButtonClick(Button button) {
        if (this.farmField == null || !button.isEnabled()) {
            return;
        }
        String directionName = button.getID().replace(DIRECTIONAL_BUTTON_ID_PREFIX, "");
        Optional<Direction> direction = Direction.Plane.HORIZONTAL.stream().filter(f -> f.getName().equals(directionName)).findFirst();
        if (direction.isEmpty()) {
            return;
        }
        int newRadius = this.farmField.getRadius(direction.get()) % this.farmField.getMaxRadius() + 1;
        this.farmField.setRadius(direction.get(), newRadius);
        button.setText(Component.literal((String)String.valueOf(newRadius)));
        new FarmFieldPlotResizeMessage(this.tileEntityScarecrow.getCurrentColony(), newRadius, direction.get(), this.farmField.getPosition()).sendToServer();
    }

    private void updateAll() {
        this.updateFarmField();
        this.updateElementStates();
        this.updateOwner();
        this.updateSeed();
        this.updateButtons();
    }

    private void setSeed(ItemStack stack) {
        IColonyView colonyView = this.getCurrentColony();
        if (colonyView != null && this.farmField != null) {
            new FarmFieldUpdateSeedMessage(colonyView, stack, this.farmField.getPosition()).sendToServer();
            this.farmField.setSeed(stack);
        }
    }

    private void updateFarmField() {
        if (this.farmField != null) {
            return;
        }
        IColonyView colonyView = this.getCurrentColony();
        if (colonyView == null) {
            return;
        }
        IBuildingExtension field = colonyView.getBuildingExtension(otherField -> otherField.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()) && otherField.getPosition().equals((Object)this.tileEntityScarecrow.getBlockPos()));
        if (field instanceof FarmField) {
            FarmField farmFieldFound;
            this.farmField = farmFieldFound = (FarmField)field;
        }
    }

    private void updateElementStates() {
        IColonyView colonyView = this.getCurrentColony();
        ((Text)this.findPaneOfTypeByID(NOT_IN_COLONY_TEXT_ID, Text.class)).setVisible(colonyView == null);
        ((Text)this.findPaneOfTypeByID(CURRENT_FARMER_TEXT_ID, Text.class)).setVisible(colonyView != null);
        ((ButtonImage)this.findPaneOfTypeByID(SELECT_SEED_BUTTON_ID, ButtonImage.class)).setVisible(colonyView != null);
        ((ItemIcon)this.findPaneOfTypeByID(CURRENT_SEED_TEXT_ID, ItemIcon.class)).setVisible(colonyView != null);
        ((ItemIcon)this.findPaneOfTypeByID(DIRECTIONAL_BUTTON_CENTER_ICON_ID, ItemIcon.class)).setVisible(colonyView != null);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ((ButtonImage)this.findPaneOfTypeByID(DIRECTIONAL_BUTTON_ID_PREFIX + dir.getName(), ButtonImage.class)).setVisible(colonyView != null);
        }
    }

    private void updateOwner() {
        ((Text)this.findPaneOfTypeByID(CURRENT_FARMER_TEXT_ID, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.field.noassignedfarmer", (Object[])new Object[0]));
        IColonyView colonyView = this.getCurrentColony();
        if (colonyView == null || this.farmField == null || !this.farmField.isTaken()) {
            return;
        }
        IBuildingView building = colonyView.getBuilding(this.farmField.getBuildingId());
        if (building == null) {
            return;
        }
        Integer citizenId = building.getAllAssignedCitizens().stream().findFirst().orElse(null);
        if (citizenId == null) {
            return;
        }
        ICitizenDataView citizen = colonyView.getCitizen(citizenId);
        if (citizen == null) {
            return;
        }
        ((Text)this.findPaneOfTypeByID(CURRENT_FARMER_TEXT_ID, Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.field.assignedfarmer", (Object[])new Object[]{citizen.getName()}));
    }

    private void updateSeed() {
        if (this.farmField != null) {
            ((ItemIcon)this.findPaneOfTypeByID(CURRENT_SEED_TEXT_ID, ItemIcon.class)).setItem(this.farmField.getSeed());
        }
    }

    private void updateButtons() {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ButtonImage button = (ButtonImage)this.findPaneOfTypeByID(DIRECTIONAL_BUTTON_ID_PREFIX + dir.getName(), ButtonImage.class);
            button.setEnabled(this.farmField != null);
            button.setText(Component.literal((String)(this.farmField == null ? "" : Integer.toString(this.farmField.getRadius(dir)))));
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)button).append(Component.translatableEscape((String)("com.minecolonies.coremod.gui.field." + dir.getSerializedName()), (Object[])new Object[0]))).appendNL(Component.translatableEscape((String)this.getDirectionalTranslationKey(dir), (Object[])new Object[0]).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY)))).build();
        }
    }

    @Nullable
    private IColonyView getCurrentColony() {
        IColony iColony = this.tileEntityScarecrow.getCurrentColony();
        if (iColony instanceof IColonyView) {
            IColonyView colonyView = (IColonyView)iColony;
            return colonyView;
        }
        return null;
    }

    private String getDirectionalTranslationKey(Direction direction) {
        Direction[] looks = Direction.orderedByNearest((Entity)Minecraft.getInstance().player);
        Direction facing = looks[0].getAxis() == Direction.Axis.Y ? looks[1] : looks[0];
        return switch (facing.getOpposite().get2DDataValue() - direction.get2DDataValue()) {
            case -3, 1 -> "com.minecolonies.coremod.gui.field.to_right";
            case -2, 2 -> "com.minecolonies.coremod.gui.field.opposite";
            case -1, 3 -> "com.minecolonies.coremod.gui.field.to_left";
            default -> "com.minecolonies.coremod.gui.field.near";
        };
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateAll();
    }
}

