/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.structurize.client.gui.WindowSwitchPack;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.core.client.gui.WindowBannerPicker;
import com.minecolonies.core.client.gui.map.WindowColonyMap;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.client.gui.townhall.WindowTownHallMercenary;
import com.minecolonies.core.client.gui.townhall.WindowTownHallNameEntry;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.event.TextureReloadListener;
import com.minecolonies.core.network.messages.server.colony.ColonyNameStyleMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyStructureStyleMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyTextureStyleMessage;
import com.minecolonies.core.network.messages.server.colony.TeamColonyColorChangeMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class WindowMainPage
extends AbstractWindowTownHall {
    private static AtomicBoolean isFeatureUnlocked = new AtomicBoolean(false);
    private DropDownList colorDropDownList;
    private DropDownList textureDropDownList;
    private DropDownList nameStyleDropDownList;
    private int initialTextureIndex;
    private int initialNamePackIndex;
    private final Text title;

    public WindowMainPage(BuildingTownHall.View building) {
        super(building, "layoutactions.xml");
        this.initDropDowns();
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        ((Button)this.findPaneOfTypeByID("actions1", Button.class)).setText(Component.translatable((String)building.getBuildingDisplayName()).append((Component)Component.literal((String)(" " + building.getBuildingLevel()))));
        this.registerButton("changeSpec", this::doNothing);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("mercenaries", this::mercenaryClicked);
        this.registerButton("map", this::mapButtonClicked);
        this.registerButton("patreon", this::patreonClicked);
        this.registerButton("colonyStylePicker", this::switchPack);
        ((ButtonImage)this.findPaneOfTypeByID("colonyStylePicker", ButtonImage.class)).setText(Component.literal((String)building.getColony().getStructurePack()));
        this.registerButton("bannerPicker", this::openBannerPicker);
        this.registerButton("resettexture", this::resetTextureStyle);
        this.colorDropDownList.setSelectedIndex(building.getColony().getTeamColonyColor().ordinal());
        this.textureDropDownList.setSelectedIndex(TextureReloadListener.TEXTURE_PACKS.indexOf(building.getColony().getTextureStyleId()));
        this.initialTextureIndex = this.textureDropDownList.getSelectedIndex();
        this.nameStyleDropDownList.setSelectedIndex(building.getColony().getNameFileIds().indexOf(building.getColony().getNameStyle()));
        this.initialNamePackIndex = this.nameStyleDropDownList.getSelectedIndex();
        this.checkFeatureUnlock();
    }

    private void switchPack() {
        new WindowSwitchPack(() -> {
            ((ITownHallView)this.buildingView).getColony().setStructurePack(StructurePacks.selectedPack.getName());
            new ColonyStructureStyleMessage(((ITownHallView)this.buildingView).getColony(), StructurePacks.selectedPack.getName()).sendToServer();
            return new WindowMainPage((BuildingTownHall.View)this.buildingView);
        }).open();
    }

    private void initDropDowns() {
        ((DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class)).setEnabled(this.enabled);
        this.colorDropDownList = (DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class);
        this.colorDropDownList.setHandler(this::onDropDownListChanged);
        final List<ChatFormatting> textColors = Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::isColor).toList();
        this.colorDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return textColors.size();
            }

            public MutableComponent getLabel(int index) {
                if (index >= 0 && index < textColors.size()) {
                    String colorName = ((ChatFormatting)textColors.get(index)).getName().replace("_", " ");
                    return Component.literal((String)(colorName.substring(0, 1).toUpperCase(Locale.US) + colorName.substring(1)));
                }
                return Component.empty();
            }
        });
        this.textureDropDownList = (DropDownList)this.findPaneOfTypeByID("textureStylePicker", DropDownList.class);
        this.textureDropDownList.setHandler(this::toggleTexture);
        this.textureDropDownList.setDataProvider(new DropDownList.DataProvider(this){

            public int getElementCount() {
                return TextureReloadListener.TEXTURE_PACKS.size();
            }

            public MutableComponent getLabel(int index) {
                return Component.literal((String)TextureReloadListener.TEXTURE_PACKS.get(index));
            }
        });
        this.nameStyleDropDownList = (DropDownList)this.findPaneOfTypeByID("nameStylePicker", DropDownList.class);
        this.nameStyleDropDownList.setHandler(this::toggleNameFile);
        this.nameStyleDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowMainPage.this.buildingView).getColony().getNameFileIds().size();
            }

            public MutableComponent getLabel(int index) {
                return Component.literal((String)((ITownHallView)WindowMainPage.this.buildingView).getColony().getNameFileIds().get(index));
            }
        });
    }

    private void toggleTexture(DropDownList dropDownList) {
        if (dropDownList.getSelectedIndex() != this.initialTextureIndex) {
            new ColonyTextureStyleMessage(((ITownHallView)this.buildingView).getColony(), TextureReloadListener.TEXTURE_PACKS.get(dropDownList.getSelectedIndex())).sendToServer();
        }
    }

    private void toggleNameFile(DropDownList dropDownList) {
        if (dropDownList.getSelectedIndex() != this.initialNamePackIndex) {
            new ColonyNameStyleMessage(((ITownHallView)this.buildingView).getColony(), ((ITownHallView)this.buildingView).getColony().getNameFileIds().get(dropDownList.getSelectedIndex())).sendToServer();
        }
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        new TeamColonyColorChangeMessage(dropDownList.getSelectedIndex(), this.buildingView).sendToServer();
    }

    private void openBannerPicker(@NotNull Button button) {
        WindowBannerPicker window = new WindowBannerPicker(((ITownHallView)this.buildingView).getColony(), this, isFeatureUnlocked);
        Minecraft.getInstance().setScreen((Screen)window);
    }

    private void resetTextureStyle() {
        new ColonyTextureStyleMessage(((ITownHallView)this.buildingView).getColony(), TextureReloadListener.TEXTURE_PACKS.get(0)).sendToServer();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        Pane textPane = this.findPaneByID("textureStylePicker");
        Pane namePane = this.findPaneByID("nameStylePicker");
        Pane resetButton = this.findPaneByID("resettexture");
        boolean isOwner = ((ITownHallView)this.buildingView).getColony().getPermissions().getOwner().equals(Minecraft.getInstance().player.getUUID());
        if (isFeatureUnlocked.get() && isOwner) {
            this.findPaneByID("patreon").hide();
            textPane.enable();
            namePane.enable();
            textPane.show();
            resetButton.hide();
        } else {
            this.findPaneByID("patreon").show();
            textPane.disable();
            namePane.disable();
            if (!((ITownHallView)this.buildingView).getColony().getTextureStyleId().equals("default")) {
                resetButton.show();
                textPane.hide();
            } else {
                textPane.show();
            }
            AbstractTextBuilder.TooltipBuilder textPaneToolTipBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane(textPane).append(Component.translatable((String)"com.minecolonies.core.townhall.patreon.textures"))).paragraphBreak()).appendNL(Component.empty())).appendNL(Component.translatable((String)"com.minecolonies.core.townhall.patreon"))).paragraphBreak();
            AbstractTextBuilder.TooltipBuilder namePaneToolTipBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane(namePane).append(Component.translatable((String)"com.minecolonies.core.townhall.patreon.names"))).paragraphBreak()).appendNL(Component.empty())).appendNL(Component.translatable((String)"com.minecolonies.core.townhall.patreon"))).paragraphBreak();
            if (isFeatureUnlocked.get() && !isOwner) {
                textPaneToolTipBuilder.appendNL(Component.empty());
                namePaneToolTipBuilder.appendNL(Component.empty());
                textPaneToolTipBuilder.appendNL(Component.translatable((String)"com.minecolonies.core.townhall.patreon.needs_owner"));
                namePaneToolTipBuilder.appendNL(Component.translatable((String)"com.minecolonies.core.townhall.patreon.needs_owner"));
            }
            textPaneToolTipBuilder.build();
            namePaneToolTipBuilder.build();
        }
    }

    public void checkFeatureUnlock() {
        isFeatureUnlocked.set(true);
    }

    private void patreonClicked() {
        Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(check -> {
            if (check) {
                Util.getPlatform().openUri("https://www.patreon.com/Minecolonies");
            }
            Minecraft.getInstance().setScreen((Screen)this.screen);
        }, "https://www.patreon.com/Minecolonies", true));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.title.setText(Component.literal((String)((ITownHallView)this.buildingView).getColony().getName()));
        if (((ITownHallView)this.buildingView).getColony().getMercenaryUseTime() != 0L && ((ITownHallView)this.buildingView).getColony().getWorld().getGameTime() - ((ITownHallView)this.buildingView).getColony().getMercenaryUseTime() < 48000L) {
            ((Button)this.findPaneOfTypeByID("mercenaries", Button.class)).disable();
        }
    }

    private void renameClicked() {
        new WindowTownHallNameEntry(((ITownHallView)this.buildingView).getColony()).open();
    }

    private void mercenaryClicked() {
        new WindowTownHallMercenary(((ITownHallView)this.buildingView).getColony()).open();
    }

    private void mapButtonClicked() {
        new WindowColonyMap(true, (ITownHallView)this.buildingView).open();
    }

    @Override
    protected String getWindowId() {
        return "actions";
    }

    private static /* synthetic */ void lambda$checkFeatureUnlock$1(String player) {
        try {
            String inputLine;
            SSLSocketFactory sslsocketfactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            URL url = new URL("https://auth.minecolonies.com/api/minecraft/" + player + "/features");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(sslsocketfactory);
            InputStream responseBody = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody));
            StringBuilder response = new StringBuilder();
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
            reader.close();
            isFeatureUnlocked.set(Boolean.parseBoolean(response.toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

