/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.model.raiders;

import com.minecolonies.api.client.render.modeltype.EgyptianModel;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMonster;
import com.minecolonies.api.entity.mobs.egyptians.AbstractEntityEgyptianRaider;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ModelPharaoh
extends EgyptianModel<AbstractEntityEgyptianRaider> {
    private ModelPart bodyGoldenStrip;
    private ModelPart jaw;

    public ModelPharaoh(ModelPart part) {
        super(part);
        this.hat.visible = false;
        this.bodyGoldenStrip = part.getChild("body").getChild("bodyGoldenStrip");
        this.jaw = part.getChild("head").getChild("jaw");
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partDefinition = meshdefinition.getRoot();
        PartDefinition leftArmDefinition = partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror().texOffs(24, 32).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)).mirror(), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftLegDefinition = partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror().texOffs(56, 20).addBox(-2.4f, -0.5f, -2.5f, 5.0f, 6.0f, 5.0f).mirror().texOffs(40, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)).mirror(), PartPose.offset((float)1.9f, (float)12.0f, (float)0.1f));
        PartDefinition bodyDefinition = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror().texOffs(44, 0).addBox(-5.5f, -0.2f, -2.5f, 11.0f, 5.0f, 5.0f, new CubeDeformation(0.15f)).mirror().texOffs(0, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)).mirror().texOffs(52, 11).addBox(-4.5f, 8.5f, -2.5f, 9.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).mirror(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyJewelDefinition = bodyDefinition.addOrReplaceChild("bodyJewel", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(-0.3f)).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition bodyGoldenStripDefinition = bodyDefinition.addOrReplaceChild("bodyGoldenStrip", CubeListBuilder.create().texOffs(38, 12).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 8.0f, 0.0f).mirror(), PartPose.offset((float)0.0f, (float)10.0f, (float)-2.6f));
        PartDefinition rightArmDefinition = partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightLegDefinition = partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).texOffs(56, 20).addBox(-2.6f, -0.5f, -2.5f, 5.0f, 6.0f, 5.0f).texOffs(24, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.1f));
        PartDefinition headDefinition = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f).mirror().texOffs(80, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.1f)).mirror().texOffs(38, 48).addBox(-3.0f, -2.0f, 0.0f, 6.0f, 2.0f, 4.0f).mirror().texOffs(14, 59).addBox(-4.5f, -2.85f, 1.0f, 9.0f, 3.0f, 0.0f).mirror().texOffs(0, 14).addBox(-2.5f, -2.0f, -3.5f, 5.0f, 1.0f, 0.0f).mirror().texOffs(10, 10).addBox(-2.5f, -2.0f, -3.5f, 0.0f, 1.0f, 4.0f).mirror().texOffs(10, 10).addBox(2.5f, -2.0f, -3.5f, 0.0f, 1.0f, 4.0f).mirror(), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition snakeBodyDefinition = headDefinition.addOrReplaceChild("snakeBody", CubeListBuilder.create().texOffs(76, 2).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)-7.5f, (float)-4.6f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition snakeHeadDefinition = headDefinition.addOrReplaceChild("snakeHead", CubeListBuilder.create().texOffs(77, 3).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.99f)).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)-10.65f, (float)-4.5f, (float)0.2793f, (float)0.0f, (float)0.0f));
        PartDefinition headRightSideTopDefinition = headDefinition.addOrReplaceChild("headRightSideTop", CubeListBuilder.create().texOffs(0, 51).addBox(-5.15f, 0.13f, 0.19f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.13f)), PartPose.offsetAndRotation((float)-4.6f, (float)-11.4f, (float)0.86f, (float)0.0f, (float)0.0f, (float)-0.8901f));
        PartDefinition headRightSideMiddleDefinition = headDefinition.addOrReplaceChild("headRightSideMiddle", CubeListBuilder.create().texOffs(14, 51).addBox(0.0f, 0.0f, 0.19f, 5.0f, 6.0f, 2.0f, new CubeDeformation(0.14f)), PartPose.offsetAndRotation((float)-7.82f, (float)-7.11f, (float)0.86f, (float)0.0f, (float)0.0f, (float)0.2688f));
        PartDefinition headRightSideBottomDefinition = headDefinition.addOrReplaceChild("headRightSideBottom", CubeListBuilder.create().texOffs(0, 57).addBox(0.0f, -1.0f, -4.0f, 3.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)-9.58f, (float)-1.23f, (float)0.91f, (float)0.0f, (float)-0.9147f, (float)0.2688f));
        PartDefinition headLeftSideTopDefinition = headDefinition.addOrReplaceChild("headLeftSideTop", CubeListBuilder.create().texOffs(0, 51).addBox(0.15f, 0.13f, 0.19f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.13f)).mirror(), PartPose.offsetAndRotation((float)4.6f, (float)-11.4f, (float)0.86f, (float)0.0f, (float)0.0f, (float)0.8901f));
        PartDefinition headLeftSideMiddleDefinition = headDefinition.addOrReplaceChild("headLeftSideMiddle", CubeListBuilder.create().texOffs(14, 51).addBox(-5.0f, 0.0f, 0.19f, 5.0f, 6.0f, 2.0f, new CubeDeformation(0.14f)).mirror(), PartPose.offsetAndRotation((float)7.82f, (float)-7.11f, (float)0.86f, (float)0.0f, (float)0.0f, (float)-0.2688f));
        PartDefinition headLeftSideBottomDefinition = headDefinition.addOrReplaceChild("headLeftSideBottom", CubeListBuilder.create().texOffs(0, 57).addBox(-3.0f, -1.0f, -4.0f, 3.0f, 1.0f, 4.0f).mirror(), PartPose.offsetAndRotation((float)9.58f, (float)-1.23f, (float)0.91f, (float)0.0f, (float)0.9147f, (float)-0.2688f));
        PartDefinition headTailDefinition = headDefinition.addOrReplaceChild("headTail", CubeListBuilder.create().texOffs(28, 51).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(-0.2f)).mirror(), PartPose.offset((float)1.5f, (float)0.4f, (float)2.5f));
        PartDefinition headTopDefinition = headDefinition.addOrReplaceChild("headTop", CubeListBuilder.create().texOffs(76, 18).addBox(-4.5f, 0.0f, 0.0f, 9.0f, 4.0f, 8.0f, new CubeDeformation(0.09f)).mirror(), PartPose.offsetAndRotation((float)0.0f, (float)-8.55f, (float)-4.45f, (float)0.4714f, (float)0.0f, (float)0.0f));
        PartDefinition headCapDefinition = headDefinition.addOrReplaceChild("headCap", CubeListBuilder.create().texOffs(18, 49).addBox(-4.5f, 0.15f, 0.19f, 9.0f, 0.0f, 2.0f, new CubeDeformation(0.13f)).mirror(), PartPose.offset((float)0.0f, (float)-11.4f, (float)0.85f));
        PartDefinition jawDefinition = headDefinition.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(33, 54).addBox(-2.5f, 1.0f, -4.0f, 5.0f, 1.0f, 5.0f).mirror().texOffs(10, 11).addBox(2.5f, 0.0f, -4.0f, 0.0f, 1.0f, 4.0f).mirror().texOffs(0, 15).addBox(-2.5f, 0.0f, -4.0f, 5.0f, 1.0f, 0.0f).mirror().texOffs(10, 11).addBox(-2.5f, 0.0f, -4.0f, 0.0f, 1.0f, 4.0f).mirror(), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    private static float sinPi(float f) {
        return Mth.sin((float)(f * (float)Math.PI));
    }

    public void setupAnim(AbstractEntityMinecoloniesMonster entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.bodyGoldenStrip.xRot = -Math.max(this.rightLeg.xRot, this.leftLeg.xRot);
        this.jaw.xRot = 0.3f - 0.1f * ModelPharaoh.sinPi(ageInTicks / 20.0f) % 2.0f;
        this.jaw.yRot = 0.05f * ModelPharaoh.sinPi((ageInTicks + 10.0f) / 20.0f) % 2.0f;
    }
}

