/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.core.blocks.BlockColonySign;
import com.minecolonies.core.tileentities.TileEntityColonySign;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityColonySignRenderer
implements BlockEntityRenderer<TileEntityColonySign> {
    private final BakedModel model;
    private final BakedModel model2;
    private final BlockRenderDispatcher renderDispatcher;

    public TileEntityColonySignRenderer(BlockEntityRendererProvider.Context context) {
        this.model = context.getBlockRenderDispatcher().getBlockModel(ModBlocks.blockColonySign.defaultBlockState());
        this.model2 = context.getBlockRenderDispatcher().getBlockModel((BlockState)ModBlocks.blockColonySign.defaultBlockState().setValue((Property)BlockColonySign.CONNECTED, (Comparable)Boolean.valueOf(true)));
        this.renderDispatcher = context.getBlockRenderDispatcher();
    }

    public void render(@NotNull TileEntityColonySign tileEntity, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tileEntity != null) {
            float relativeRotationToColony = tileEntity.getRelativeRotation();
            BlockState state = tileEntity.getLevel().getBlockState(tileEntity.getBlockPos());
            if (state.getBlock() == ModBlocks.blockColonySign) {
                matrixStack.pushPose();
                matrixStack.translate(0.5, 0.5, 0.5);
                matrixStack.mulPose(Axis.YP.rotationDegrees(relativeRotationToColony));
                matrixStack.translate(-0.5, -0.5, -0.5);
                this.renderSingleBlock(state, matrixStack, buffer, combinedLight, combinedOverlay, tileEntity.getTargetColonyId() != -1);
                matrixStack.popPose();
                matrixStack.pushPose();
                matrixStack.translate(0.5f, 0.5f, 0.5f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(relativeRotationToColony));
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStack.translate(-0.0f, -0.1f, 0.2f);
                matrixStack.scale(0.007f, -0.007f, 0.007f);
                String colonyName = tileEntity.getColonyName();
                int distance = tileEntity.getColonyDistance();
                if (colonyName.isEmpty()) {
                    this.renderText(matrixStack, buffer, combinedLight, "Unknown Colony", 0, 0.0f);
                    this.renderText(matrixStack, buffer, combinedLight, Component.translatable((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance}).getString(), 3, 0.0f);
                } else {
                    String targetColonyName = tileEntity.getTargetColonyName();
                    if (!targetColonyName.isEmpty()) {
                        int targetColonyDistance = tileEntity.getTargetColonyDistance();
                        this.renderColonyNameOnSign(colonyName, matrixStack, buffer, combinedLight, distance, -10);
                        this.renderColonyNameOnSign(targetColonyName, matrixStack, buffer, combinedLight, targetColonyDistance, -60);
                    } else {
                        this.renderColonyNameOnSign(colonyName, matrixStack, buffer, combinedLight, distance, 0);
                    }
                }
                matrixStack.popPose();
            }
        }
    }

    private void renderColonyNameOnSign(String colonyName, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int distance, int offset) {
        int textWidth = Minecraft.getInstance().font.width(colonyName);
        if (textWidth > 90) {
            List splitName = Minecraft.getInstance().font.getSplitter().splitLines(colonyName, 90, Style.EMPTY);
            for (int i = 0; i < Math.min(2, splitName.size()); ++i) {
                this.renderText(matrixStack, buffer, combinedLight, ((FormattedText)splitName.get(i)).getString(), i, offset);
            }
            this.renderText(matrixStack, buffer, combinedLight, Component.translatable((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance}).getString(), 3, offset);
        } else {
            this.renderText(matrixStack, buffer, combinedLight, colonyName, 0, offset);
            this.renderText(matrixStack, buffer, combinedLight, Component.translatable((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance}).getString(), 3, offset);
        }
    }

    private void renderSingleBlock(BlockState state, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay, boolean connected) {
        BakedModel usedModel = connected ? this.model2 : this.model;
        for (RenderType rt : usedModel.getRenderTypes(state, RandomSource.create((long)42L), ModelData.EMPTY)) {
            this.renderDispatcher.getModelRenderer().renderModel(pose.last(), buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), state, usedModel, 0.0f, 0.0f, 0.0f, combinedLight, combinedOverlay, ModelData.EMPTY, rt);
        }
    }

    private void renderText(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, String text, int line, float offset) {
        FormattedCharSequence iReorderingProcessor;
        int maxSize = 20;
        if (text.length() > 20) {
            text = text.substring(0, 20);
        }
        if ((iReorderingProcessor = FormattedCharSequence.forward((String)text, (Style)Style.EMPTY)) != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            float x = -fontRenderer.width(iReorderingProcessor) / 2;
            fontRenderer.drawInBatch(iReorderingProcessor, x, (float)line * 8.0f + offset, -589505536, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        }
    }

    public boolean shouldRenderOffScreen(TileEntityColonySign tileEntityMBE21) {
        return false;
    }
}

