/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PathfindingDebugRenderer {
    public static Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesVisitedLater = new HashSet<MNode>();
    public static Set<MNode> debugNodesOrgPath = new HashSet<MNode>();
    public static Set<MNode> debugNodesExtra = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesPath = new HashSet<MNode>();

    static void render(WorldEventContext ctx) {
        try {
            for (MNode n : lastDebugNodesVisited) {
                PathfindingDebugRenderer.debugDrawNode(n, -65536, ctx);
            }
            for (MNode n : lastDebugNodesVisitedLater) {
                PathfindingDebugRenderer.debugDrawNode(n, -44976, ctx);
            }
            for (MNode n : debugNodesOrgPath) {
                PathfindingDebugRenderer.debugDrawNode(n, -8355712, ctx);
            }
            for (MNode n : debugNodesExtra) {
                PathfindingDebugRenderer.debugDrawNode(n, -6710785, ctx);
            }
            for (MNode n : lastDebugNodesNotVisited) {
                PathfindingDebugRenderer.debugDrawNode(n, -16776961, ctx);
            }
            for (MNode n : lastDebugNodesPath) {
                if (n.isReachedByWorker()) {
                    PathfindingDebugRenderer.debugDrawNode(n, -256, ctx);
                    continue;
                }
                PathfindingDebugRenderer.debugDrawNode(n, -16711936, ctx);
            }
        }
        catch (ConcurrentModificationException exc) {
            Log.getLogger().catching((Throwable)exc);
        }
    }

    private static void debugDrawNode(MNode n, int argbColor, WorldEventContext ctx) {
        ctx.poseStack.pushPose();
        ctx.poseStack.translate((double)n.x + 0.375 - ctx.cameraPosition.x, (double)n.y + 0.375 - ctx.cameraPosition.y, (double)n.z + 0.375 - ctx.cameraPosition.z);
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if ((double)BlockPosUtil.distSqr(entity.blockPosition(), n.x, n.y, n.z) < 25.0) {
            PathfindingDebugRenderer.renderDebugText(n, ctx);
        }
        ctx.poseStack.scale(0.25f, 0.25f, 0.25f);
        ctx.renderBox(WorldEventContext.COLORED_TRIANGLES, BlockPos.ZERO, BlockPos.ZERO, argbColor);
        if (n.parent != null) {
            Matrix4f lineMatrix = ctx.poseStack.last().pose();
            float pdx = (float)(n.parent.x - n.x) + 0.125f;
            float pdy = (float)(n.parent.y - n.y) + 0.125f;
            float pdz = (float)(n.parent.z - n.z) + 0.125f;
            VertexConsumer buffer = ctx.bufferSource.getBuffer(WorldRenderMacros.LINES);
            buffer.addVertex(lineMatrix, 0.5f, 0.5f, 0.5f).setColor(0.75f, 0.75f, 0.75f, 1.0f);
            buffer.addVertex(lineMatrix, pdx / 0.25f, pdy / 0.25f, pdz / 0.25f).setColor(0.75f, 0.75f, 0.75f, 1.0f);
        }
        ctx.poseStack.popPose();
    }

    private static void renderDebugText(@NotNull MNode n, WorldEventContext ctx) {
        Font fontrenderer = ctx.mc.font;
        String s1 = String.format("C: %.1f", n.getCost());
        String s2 = String.format("H: %.1f", n.getHeuristic());
        int i = Math.max(fontrenderer.width(s1), fontrenderer.width(s2)) / 2;
        ctx.poseStack.pushPose();
        ctx.poseStack.translate(0.0f, 0.6f, 0.0f);
        ctx.poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        ctx.poseStack.scale(0.014f, -0.014f, 0.014f);
        Matrix4f mat = ctx.poseStack.last().pose();
        ctx.renderFillRectangle(-i - 1, -5, 0, 2 * i + 2, 17, 0x7F000000);
        ctx.poseStack.translate(0.0f, -5.0f, -0.1f);
        fontrenderer.drawInBatch(s1, (float)(-fontrenderer.width(s1)) / 2.0f, 1.0f, -1, false, mat, (MultiBufferSource)ctx.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ctx.poseStack.translate(0.0f, 8.0f, -0.1f);
        fontrenderer.drawInBatch(s2, (float)(-fontrenderer.width(s2)) / 2.0f, 1.0f, -1, false, mat, (MultiBufferSource)ctx.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        ctx.poseStack.popPose();
    }
}

