/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.claim.ChunkClaimData;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.colony.connections.IColonyConnectionManager;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.events.raid.RaidManager;
import com.minecolonies.core.colony.managers.CitizenManager;
import com.minecolonies.core.colony.managers.ColonyConnectionManager;
import com.minecolonies.core.colony.managers.ColonyPackageManager;
import com.minecolonies.core.colony.managers.EventDescriptionManager;
import com.minecolonies.core.colony.managers.EventManager;
import com.minecolonies.core.colony.managers.GraveManager;
import com.minecolonies.core.colony.managers.RegisteredStructureManager;
import com.minecolonies.core.colony.managers.ReproductionManager;
import com.minecolonies.core.colony.managers.ResearchManager;
import com.minecolonies.core.colony.managers.StatisticsManager;
import com.minecolonies.core.colony.managers.TravellingManager;
import com.minecolonies.core.colony.managers.VisitorManager;
import com.minecolonies.core.colony.permissions.ColonyPermissionEventHandler;
import com.minecolonies.core.colony.permissions.Permissions;
import com.minecolonies.core.colony.pvp.AttackingPlayer;
import com.minecolonies.core.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.core.colony.workorders.WorkManager;
import com.minecolonies.core.datalistener.CitizenNameListener;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.core.quests.QuestManager;
import com.minecolonies.core.util.BackUpHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private String pack = "Colonial";
    private final int id;
    private ResourceKey<Level> dimensionId;
    private final ConcurrentHashMap<Long, Long> loadedChunks = new ConcurrentHashMap();
    public Set<Long> ticketedChunks = new HashSet<Long>();
    private boolean ticketedChunksDirty = true;
    private final Set<Long> pendingChunks = new HashSet<Long>();
    private final Set<Long> pendingToUnloadChunks = new HashSet<Long>();
    private final Map<BlockPos, BlockState> wayPoints = new HashMap<BlockPos, BlockState>();
    private final WorkManager workManager;
    private final IRegisteredStructureManager buildingManager;
    private final IGraveManager graveManager;
    private final ICitizenManager citizenManager;
    private final IVisitorManager visitorManager;
    private final IRaiderManager raidManager;
    private final IEventManager eventManager;
    private final IReproductionManager reproductionManager;
    private final IEventDescriptionManager eventDescManager;
    private final IColonyPackageManager packageManager;
    private final IStatisticsManager statisticManager;
    private final IQuestManager questManager;
    private final Permissions permissions;
    private IRequestManager requestManager;
    private final IResearchManager researchManager;
    private final TravellingManager travellingManager = new TravellingManager(this);
    private final ColonyConnectionManager connectionManager = new ColonyConnectionManager(this);
    private ImmutableSet<BlockPos> freePositions = ImmutableSet.of();
    private ImmutableSet<Block> freeBlocks = ImmutableSet.of();
    private ColonyPermissionEventHandler eventHandler;
    private boolean canColonyBeAutoDeleted = true;
    private boolean isDay = true;
    @Nullable
    private ServerLevel world = null;
    private String name;
    private final BlockPos center;
    private CompoundTag colonyTag;
    private final List<Player> visitingPlayers = new ArrayList<Player>();
    private final List<AttackingPlayer> attackingPlayers = new ArrayList<AttackingPlayer>();
    private ITickRateStateMachine<ColonyState> colonyStateMachine = null;
    private boolean isDirty = true;
    private ChatFormatting colonyTeamColor = ChatFormatting.WHITE;
    private BannerPatternLayers colonyFlag;
    private long mercenaryLastUse = 0L;
    private int additionalChildTime = 0;
    private static final int maxAdditionalChildTime = 70000;
    private boolean hasChilds = false;
    public long lastOnlineTime = 0L;
    private int forceLoadTimer = 0;
    private String textureStyle = "default";
    private String nameStyle = "default";
    private int day = 0;
    private final Long2ObjectMap<ChunkClaimData> claimData = new Long2ObjectOpenHashMap();
    private final SettingsModule settingsModule;

    Colony(int id, String name, @Nullable ServerLevel world, BlockPos center) {
        this.settingsModule = (SettingsModule)BuildingEntry.produceModuleWithoutBuilding(BuildingModules.TOWNHALL_SETTINGS.key);
        this.id = id;
        this.name = name;
        this.center = center;
        this.workManager = new WorkManager(this);
        this.buildingManager = new RegisteredStructureManager(this);
        this.graveManager = new GraveManager(this);
        this.citizenManager = new CitizenManager(this);
        this.visitorManager = new VisitorManager(this);
        this.raidManager = new RaidManager(this);
        this.eventManager = new EventManager(this);
        this.reproductionManager = new ReproductionManager(this);
        this.eventDescManager = new EventDescriptionManager(this);
        this.packageManager = new ColonyPackageManager(this);
        this.statisticManager = new StatisticsManager();
        this.questManager = new QuestManager(this);
        this.permissions = new Permissions(this);
        this.researchManager = new ResearchManager(this);
        if (world != null) {
            this.colonyFlag = new BannerPatternLayers.Builder().add(Utils.getRegistryValue(BannerPatterns.BASE, (Level)world), DyeColor.WHITE).build();
            this.dimensionId = world.dimension();
            this.onWorldLoad(world);
        }
        this.colonyStateMachine = new TickRateStateMachine<ColonyState>(ColonyState.INACTIVE, e -> {
            Log.getLogger().warn("Exception triggered in colony:{} in dimension:{} history:{}", (Object)this.getID(), (Object)this.getDimension().location(), (Object)this.colonyStateMachine.getHistory(), e);
            this.colonyStateMachine.setCurrentDelay(6000);
        });
        this.colonyStateMachine.setHistoryEnabled(true, 10);
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.INACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, () -> {
            this.citizenManager.tickCitizenData(60);
            return false;
        }, () -> ColonyState.ACTIVE, 60));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateSubscribers, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::tickRequests, () -> ColonyState.ACTIVE, 11));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::tickTravellers, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::checkDayTime, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateWayPoints, () -> ColonyState.ACTIVE, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::worldTickSlow, () -> ColonyState.ACTIVE, 500));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::tickWorkManager, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, this::worldTickUnloaded, () -> ColonyState.UNLOADED, 500));
    }

    private ColonyState updateState() {
        if (this.world == null) {
            return ColonyState.INACTIVE;
        }
        this.packageManager.updateAwayTime();
        if (!this.packageManager.getCloseSubscribers().isEmpty() || this.loadedChunks.size() > 40 && !this.packageManager.getImportantColonyPlayers().isEmpty()) {
            this.isDirty = true;
            return ColonyState.ACTIVE;
        }
        if (!this.packageManager.getImportantColonyPlayers().isEmpty() || this.forceLoadTimer > 0) {
            this.isDirty = true;
            return ColonyState.UNLOADED;
        }
        return ColonyState.INACTIVE;
    }

    private boolean updateSubscribers() {
        this.packageManager.updateSubscribers();
        return false;
    }

    private boolean tickRequests() {
        this.getRequestManager().tick();
        return false;
    }

    private boolean tickTravellers() {
        if (this.getTravellingManager() != null) {
            return !this.getTravellingManager().onTick();
        }
        return false;
    }

    private boolean worldTickSlow() {
        long pastTime;
        this.buildingManager.cleanUpBuildings(this);
        this.citizenManager.onColonyTick(this);
        this.visitorManager.onColonyTick(this);
        this.updateAttackingPlayers();
        this.eventManager.onColonyTick(this);
        this.buildingManager.onColonyTick(this);
        this.graveManager.onColonyTick(this);
        this.reproductionManager.onColonyTick(this);
        this.questManager.onColonyTick();
        long currTime = System.currentTimeMillis();
        if (this.lastOnlineTime != 0L && (pastTime = currTime - this.lastOnlineTime) > 3600000L) {
            for (IBuilding building : this.buildingManager.getBuildings().values()) {
                building.processOfflineTime(pastTime / 1000L);
            }
        }
        this.lastOnlineTime = currTime;
        this.updateChildTime();
        this.updateChunkLoadTimer();
        return false;
    }

    private boolean tickWorkManager() {
        this.workManager.onColonyTick(this);
        return false;
    }

    private void updateChunkLoadTimer() {
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).forceLoadColony.get()).booleanValue()) {
            for (ServerPlayer sub : this.getPackageManager().getCloseSubscribers()) {
                if (!this.getPermissions().hasPermission((Player)sub, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY)) continue;
                this.forceLoadTimer = (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).loadtime.get() * 20 * 60;
                this.pendingChunks.addAll(this.pendingToUnloadChunks);
                for (long pending : this.pendingChunks) {
                    this.checkChunkAndRegisterTicket(pending, this.world.getChunk(ChunkPos.getX((long)pending), ChunkPos.getZ((long)pending)));
                }
                this.pendingToUnloadChunks.clear();
                this.pendingChunks.clear();
                return;
            }
            if (this.forceLoadTimer > 0) {
                this.forceLoadTimer -= 500;
                if (this.forceLoadTimer <= 0) {
                    Iterator<Object> iterator = this.ticketedChunks.iterator();
                    while (iterator.hasNext()) {
                        long chunkPos = (Long)iterator.next();
                        int chunkX = ChunkPos.getX((long)chunkPos);
                        int chunkZ = ChunkPos.getZ((long)chunkPos);
                        if (!(this.world instanceof ServerLevel)) continue;
                        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                        this.world.getChunkSource().removeRegionTicket(ColonyConstants.KEEP_LOADED_TYPE, pos, 2, (Object)pos);
                        this.pendingToUnloadChunks.add(chunkPos);
                    }
                    this.ticketedChunks.clear();
                    this.ticketedChunksDirty = true;
                }
            }
        }
    }

    private void checkChunkAndRegisterTicket(long chunkPos, LevelChunk chunk) {
        if (this.forceLoadTimer > 0 && this.world instanceof ServerLevel && !this.ticketedChunks.contains(chunkPos) && this.buildingManager.keepChunkColonyLoaded(chunk)) {
            this.ticketedChunks.add(chunkPos);
            this.ticketedChunksDirty = true;
            this.world.getChunkSource().addRegionTicket(ColonyConstants.KEEP_LOADED_TYPE, chunk.getPos(), 2, (Object)chunk.getPos(), true);
        }
    }

    private boolean worldTickUnloaded() {
        this.updateChildTime();
        this.updateChunkLoadTimer();
        return false;
    }

    private void updateChildTime() {
        this.additionalChildTime = this.hasChilds && this.additionalChildTime < 70000 ? (this.additionalChildTime += 500) : 0;
    }

    private boolean checkDayTime() {
        if (this.isDay && !WorldUtil.isDayTime((Level)this.world)) {
            this.isDay = false;
            this.eventManager.onNightFall();
            this.raidManager.onNightFall();
            if (!this.packageManager.getCloseSubscribers().isEmpty()) {
                this.citizenManager.checkCitizensForHappiness();
            }
            this.citizenManager.updateCitizenSleep(false);
        } else if (!this.isDay && WorldUtil.isDayTime((Level)this.world)) {
            this.isDay = true;
            ++this.day;
            this.citizenManager.onWakeUp();
        }
        return false;
    }

    public void updateAttackingPlayers() {
        ArrayList<Player> visitors = new ArrayList<Player>(this.visitingPlayers);
        for (Player player : visitors) {
            if (this.packageManager.getCloseSubscribers().contains(player)) continue;
            this.visitingPlayers.remove(player);
            this.attackingPlayers.remove(new AttackingPlayer(player));
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (attackingPlayer.getGuards().isEmpty()) continue;
            attackingPlayer.refreshList(this);
            if (!attackingPlayer.getGuards().isEmpty()) continue;
            MessageUtils.format("com.minecolonies.coremod.pvp.defended.success", attackingPlayer.getPlayer().getName()).sendTo(this).forManagers();
        }
    }

    @Override
    public void setColonyColor(ChatFormatting colonyColor) {
        if (this.world != null) {
            this.colonyTeamColor = colonyColor;
        }
        this.markDirty();
    }

    @Override
    public void setColonyFlag(BannerPatternLayers colonyFlag) {
        this.colonyFlag = colonyFlag;
        if (this.researchManager.getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0) {
            this.citizenManager.onFlagChange();
        }
        this.markDirty();
    }

    @Nullable
    public static Colony loadColony(@NotNull CompoundTag compound, @Nullable ServerLevel world, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        try {
            int id = compound.getInt("id");
            String name = compound.getString("name");
            BlockPos center = BlockPosUtil.read(compound, "center");
            @NotNull Colony c = new Colony(id, name, world, center);
            c.dimensionId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)compound.getString("dimension")));
            c.read(compound, provider);
            return c;
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong loading a colony, please report this to the administrators", (Throwable)e);
            return null;
        }
    }

    @Override
    public void read(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        this.dimensionId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)compound.getString("dimension")));
        this.mercenaryLastUse = compound.getLong("mercenaryUseTime");
        this.additionalChildTime = compound.getInt("childTime");
        this.permissions.loadPermissions(compound);
        this.citizenManager.read(provider, compound.getCompound("citizenManager"));
        this.visitorManager.read(provider, compound);
        this.buildingManager.read(provider, compound.getCompound("buildingManager"));
        this.citizenManager.afterBuildingLoad();
        this.graveManager.read(compound.getCompound("graveManager"));
        this.eventManager.readFromNBT(provider, compound);
        this.statisticManager.readFromNBT(compound);
        this.questManager.deserializeNBT(provider, (Tag)compound.getCompound("quest_manager"));
        this.eventDescManager.deserializeNBT(provider, (Tag)compound.getCompound("event_desc_manager"));
        if (compound.contains("research")) {
            this.researchManager.readFromNBT(provider, compound.getCompound("research"));
            this.researchManager.checkAutoStartResearch();
        }
        this.workManager.read(compound.getCompound("work"));
        this.wayPoints.clear();
        ListTag wayPointTagList = compound.getList("waypoints", 10);
        for (int i = 0; i < wayPointTagList.size(); ++i) {
            CompoundTag blockAtPos = wayPointTagList.getCompound(i);
            BlockPos pos = BlockPosUtil.read(blockAtPos, "waypoints");
            BlockState state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        HashSet<Block> tempFreeBlocks = new HashSet<Block>();
        ListTag freeBlockTagList = compound.getList("freeBlocks", 8);
        for (int i = 0; i < freeBlockTagList.size(); ++i) {
            tempFreeBlocks.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)freeBlockTagList.getString(i))));
        }
        this.freeBlocks = ImmutableSet.copyOf(tempFreeBlocks);
        HashSet<BlockPos> tempFreePositions = new HashSet<BlockPos>();
        ListTag freePositionTagList = compound.getList("freePositions", 10);
        for (int i = 0; i < freePositionTagList.size(); ++i) {
            CompoundTag blockTag = freePositionTagList.getCompound(i);
            BlockPos block = BlockPosUtil.read(blockTag, "freePositions");
            tempFreePositions.add(block);
        }
        this.freePositions = ImmutableSet.copyOf(tempFreePositions);
        this.packageManager.setLastContactInHours(compound.getInt("abandoned"));
        this.pack = compound.contains("style") ? BlueprintMapping.getStyleMapping(compound.getString("style")) : compound.getString("pack");
        this.raidManager.read(compound);
        this.canColonyBeAutoDeleted = compound.contains("autoDelete") ? compound.getBoolean("autoDelete") : true;
        if (compound.contains("teamcolor")) {
            this.colonyTeamColor = ChatFormatting.values()[compound.getInt("teamcolor")];
        }
        if (compound.contains("colonyflag")) {
            this.setColonyFlag((BannerPatternLayers)Utils.deserializeCodecMess(BannerPatternLayers.CODEC, provider, compound.get("colonyflag")));
        }
        this.getRequestManager().reset();
        if (compound.contains("requestManager")) {
            this.getRequestManager().deserializeNBT(provider, (Tag)compound.getCompound("requestManager"));
        }
        this.lastOnlineTime = compound.getLong("lastOnlineTime");
        if (compound.contains("textstyle")) {
            this.textureStyle = compound.getString("textstyle");
        }
        if (compound.contains("namestyle")) {
            this.nameStyle = compound.getString("namestyle");
        }
        if (compound.contains(BuildingModules.TOWNHALL_SETTINGS.key) && this.settingsModule != null) {
            this.settingsModule.deserializeNBT(provider, compound.getCompound(BuildingModules.TOWNHALL_SETTINGS.key));
        }
        @NotNull ListTag claimTagList = compound.getList("colonyclaimdata", 10);
        for (int i = 0; i < claimTagList.size(); ++i) {
            @NotNull CompoundTag chunkCompound = claimTagList.getCompound(i);
            ChunkClaimData chunkClaimData = new ChunkClaimData();
            chunkClaimData.deserializeNBT(provider, chunkCompound.getCompound("chunkclaimdata"));
            this.claimData.put(chunkCompound.getLong("chunkpos"), (Object)chunkClaimData);
        }
        IColonyManager.getInstance().addClaimData(this, this.claimData);
        this.day = compound.getInt("colonyday");
        this.colonyTag = compound;
        if (compound.contains("travellingData")) {
            this.travellingManager.deserializeNBT(provider, compound.getCompound("travellingData"));
        }
        if (compound.contains("connectionmanager")) {
            this.connectionManager.deserializeNBT(provider, compound.getCompound("connectionmanager"));
        }
    }

    public ColonyPermissionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public CompoundTag write(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        compound.putInt("data_version", 1);
        compound.putInt("id", this.id);
        compound.putString("dimension", this.dimensionId.location().toString());
        compound.putString("name", this.name);
        BlockPosUtil.write(compound, "center", this.center);
        compound.putLong("mercenaryUseTime", this.mercenaryLastUse);
        compound.putInt("childTime", this.additionalChildTime);
        this.permissions.savePermissions(compound);
        CompoundTag buildingCompound = new CompoundTag();
        this.buildingManager.write(provider, buildingCompound);
        compound.put("buildingManager", (Tag)buildingCompound);
        CompoundTag citizenCompound = new CompoundTag();
        this.citizenManager.write(provider, citizenCompound);
        compound.put("citizenManager", (Tag)citizenCompound);
        this.visitorManager.write(provider, compound);
        CompoundTag graveCompound = new CompoundTag();
        this.graveManager.write(graveCompound);
        compound.put("graveManager", (Tag)graveCompound);
        @NotNull CompoundTag workManagerCompound = new CompoundTag();
        this.workManager.write(workManagerCompound);
        compound.put("work", (Tag)workManagerCompound);
        this.eventManager.writeToNBT(provider, compound);
        this.statisticManager.writeToNBT(compound);
        compound.put("quest_manager", this.questManager.serializeNBT(provider));
        compound.put("event_desc_manager", this.eventDescManager.serializeNBT(provider));
        this.raidManager.write(compound);
        @NotNull CompoundTag researchManagerCompound = new CompoundTag();
        this.researchManager.writeToNBT(provider, researchManagerCompound);
        compound.put("research", (Tag)researchManagerCompound);
        @NotNull ListTag wayPointTagList = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : this.wayPoints.entrySet()) {
            @NotNull CompoundTag wayPointCompound = new CompoundTag();
            BlockPosUtil.write(wayPointCompound, "waypoints", entry.getKey());
            wayPointCompound.put("block", (Tag)NbtUtils.writeBlockState((BlockState)entry.getValue()));
            wayPointTagList.add((Object)wayPointCompound);
        }
        compound.put("waypoints", (Tag)wayPointTagList);
        @NotNull ListTag freeBlocksTagList = new ListTag();
        for (Block block : this.freeBlocks) {
            freeBlocksTagList.add((Object)StringTag.valueOf((String)BuiltInRegistries.BLOCK.getKey((Object)block).toString()));
        }
        compound.put("freeBlocks", (Tag)freeBlocksTagList);
        @NotNull ListTag listTag = new ListTag();
        for (BlockPos pos : this.freePositions) {
            @NotNull CompoundTag wayPointCompound = new CompoundTag();
            BlockPosUtil.write(wayPointCompound, "freePositions", pos);
            listTag.add((Object)wayPointCompound);
        }
        compound.put("freePositions", (Tag)listTag);
        compound.putInt("abandoned", this.packageManager.getLastContactInHours());
        compound.put("requestManager", this.getRequestManager().serializeNBT(provider));
        compound.putString("pack", this.pack);
        compound.putBoolean("autoDelete", this.canColonyBeAutoDeleted);
        compound.putInt("teamcolor", this.colonyTeamColor.ordinal());
        compound.put("colonyflag", Utils.serializeCodecMess(BannerPatternLayers.CODEC, provider, this.colonyFlag));
        compound.putLong("lastOnlineTime", this.lastOnlineTime);
        compound.putString("textstyle", this.textureStyle);
        compound.putString("namestyle", this.nameStyle);
        compound.putInt("colonyday", this.day);
        CompoundTag settings = new CompoundTag();
        this.settingsModule.serializeNBT(provider, settings);
        compound.put(BuildingModules.TOWNHALL_SETTINGS.key, (Tag)settings);
        compound.put("travellingData", (Tag)this.travellingManager.serializeNBT(provider));
        compound.put("connectionmanager", (Tag)this.connectionManager.serializeNBT(provider));
        @NotNull ListTag claimTagList = new ListTag();
        for (Long2ObjectMap.Entry chunkClaimData : this.claimData.long2ObjectEntrySet()) {
            @NotNull CompoundTag chunkCompound = new CompoundTag();
            chunkCompound.put("chunkclaimdata", (Tag)((ChunkClaimData)chunkClaimData.getValue()).serializeNBT(provider));
            chunkCompound.putLong("chunkpos", chunkClaimData.getLongKey());
            claimTagList.add((Object)chunkCompound);
        }
        compound.put("colonyclaimdata", (Tag)claimTagList);
        this.colonyTag = compound;
        this.isDirty = false;
        return compound;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public IResearchManager getResearchManager() {
        return this.researchManager;
    }

    @Override
    public void onWorldLoad(@NotNull ServerLevel w) {
        if (w.dimension() == this.dimensionId) {
            this.world = w;
            if (this.eventHandler == null) {
                this.eventHandler = new ColonyPermissionEventHandler(this);
                this.questManager.onWorldLoad();
                NeoForge.EVENT_BUS.register((Object)this.eventHandler);
                IChunkClaimData data = (IChunkClaimData)this.claimData.get(ChunkPos.asLong((BlockPos)this.getCenter()));
                if (data == null || !data.getStaticClaimColonies().contains(this.getID())) {
                    BackUpHelper.reclaimChunks(this);
                }
            }
            this.setColonyColor(this.colonyTeamColor);
        }
    }

    @Override
    public void onWorldUnload(@NotNull Level w) {
        if (w != this.world) {
            return;
        }
        if (this.eventHandler != null) {
            NeoForge.EVENT_BUS.unregister((Object)this.eventHandler);
        }
        this.world = null;
    }

    @Override
    public void onServerTick(@NotNull ServerTickEvent.Pre event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return this.workManager;
    }

    public Set<BlockPos> getFreePositions() {
        return this.freePositions;
    }

    public Set<Block> getFreeBlocks() {
        return this.freeBlocks;
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.freePositions);
        builder.add((Object)pos);
        this.freePositions = builder.build();
        this.markDirty();
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.freeBlocks);
        builder.add((Object)block);
        this.freeBlocks = builder.build();
        this.markDirty();
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BlockPos tempPos : this.freePositions) {
            if (pos.equals((Object)tempPos)) continue;
            builder.add((Object)tempPos);
        }
        this.freePositions = builder.build();
        this.markDirty();
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Block tempBlock : this.freeBlocks) {
            if (block == tempBlock) continue;
            builder.add((Object)tempBlock);
        }
        this.freeBlocks = builder.build();
        this.markDirty();
    }

    @Override
    public void onWorldTick(@NotNull LevelTickEvent.Pre event) {
        if (event.getLevel() != this.getWorld()) {
            return;
        }
        if (!event.getLevel().isClientSide && (event.getLevel().getGameTime() + (long)this.id) % 20L == 0L) {
            this.connectionManager.tick();
        }
        this.colonyStateMachine.tick();
    }

    public static boolean shallUpdate(Level world, int averageTicks) {
        return world.getGameTime() % (long)(world.random.nextInt(averageTicks * 2) + 1) == 0L;
    }

    private boolean updateWayPoints() {
        if (!this.wayPoints.isEmpty() && this.world != null) {
            int randomPos = this.world.random.nextInt(this.wayPoints.size());
            int count = 0;
            for (Map.Entry<BlockPos, BlockState> entry : this.wayPoints.entrySet()) {
                Block worldBlock;
                if (count++ != randomPos) continue;
                if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, entry.getKey()) && ((worldBlock = this.world.getBlockState(entry.getKey()).getBlock()) != entry.getValue().getBlock() && entry.getValue().getBlock() != ModBlocks.blockWayPoint && worldBlock != ModBlocks.blockConstructionTape || this.world.isEmptyBlock(entry.getKey().below()) && !BlockUtils.isAnySolid((BlockState)entry.getValue()))) {
                    this.wayPoints.remove(entry.getKey());
                    this.markDirty();
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull Level w, @NotNull BlockPos pos) {
        if (w.dimension() != this.dimensionId) {
            return false;
        }
        LevelChunk chunk = w.getChunkAt(pos);
        return ColonyUtils.getOwningColony((ChunkAccess)chunk) == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.buildingManager.hasTownHall();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.buildingManager.hasWarehouse();
    }

    @Override
    public boolean hasBuilding(ResourceLocation name, int level, boolean singleBuilding) {
        int sum = 0;
        for (IBuilding building : this.getBuildingManager().getBuildings().values()) {
            if (!building.getBuildingType().getRegistryName().equals((Object)name) || !(singleBuilding ? building.getBuildingLevel() >= level : (sum += building.getBuildingLevel()) >= level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLastContactInHours() {
        return this.packageManager.getLastContactInHours();
    }

    @Nullable
    public ServerLevel getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IRequestManager getRequestManager() {
        if (this.requestManager == null) {
            this.requestManager = new StandardRequestManager(this);
        }
        return this.requestManager;
    }

    @Override
    public void markDirty() {
        this.packageManager.setDirty();
        this.isDirty = true;
    }

    @Override
    public boolean canBeAutoDeleted() {
        return this.canColonyBeAutoDeleted;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.buildingManager.getBuilding(pos);
    }

    @Override
    @NotNull
    public List<Player> getMessagePlayerEntities() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (ServerPlayer player : this.packageManager.getCloseSubscribers()) {
            if (!this.permissions.hasPermission((Player)player, Action.RECEIVE_MESSAGES)) continue;
            players.add((Player)player);
        }
        return players;
    }

    @Override
    @NotNull
    public List<Player> getImportantMessageEntityPlayers() {
        HashSet<Player> playerList = new HashSet<Player>(this.getMessagePlayerEntities());
        for (ServerPlayer player : this.packageManager.getImportantColonyPlayers()) {
            if (!this.permissions.hasPermission((Player)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
            playerList.add((Player)player);
        }
        return new ArrayList<Player>(playerList);
    }

    @Override
    public boolean isManualHiring() {
        return this.settingsModule.getSetting(BuildingTownHall.AUTO_HIRING_MODE).getValue() == false;
    }

    @Override
    public boolean isManualHousing() {
        return this.settingsModule.getSetting(BuildingTownHall.AUTO_HOUSING_MODE).getValue() == false;
    }

    @Override
    public boolean canMoveIn() {
        return this.settingsModule.getSetting(BuildingTownHall.MOVE_IN).getValue();
    }

    public void removeWorkOrderInView(int orderId) {
        new ColonyViewRemoveWorkOrderMessage(this, orderId).sendToPlayer(this.packageManager.getCloseSubscribers());
    }

    @Override
    public void addWayPoint(BlockPos point, BlockState block) {
        this.wayPoints.put(point, block);
        this.markDirty();
    }

    @Override
    public double getOverallHappiness() {
        if (this.citizenManager.getCitizens().size() <= 0) {
            return 5.5;
        }
        double happinessSum = 0.0;
        for (ICitizenData citizen : this.citizenManager.getCitizens()) {
            happinessSum += citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony(), citizen);
        }
        return happinessSum / (double)this.citizenManager.getCitizens().size();
    }

    @Override
    public Map<BlockPos, BlockState> getWayPoints() {
        return new HashMap<BlockPos, BlockState>(this.wayPoints);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
        this.canColonyBeAutoDeleted = canBeDeleted;
        this.markDirty();
    }

    @Override
    public String getStructurePack() {
        return this.pack;
    }

    @Override
    public void setStructurePack(String style) {
        this.pack = style;
        this.markDirty();
    }

    @Override
    public IRegisteredStructureManager getBuildingManager() {
        return this.buildingManager;
    }

    @Override
    public IGraveManager getGraveManager() {
        return this.graveManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return this.citizenManager;
    }

    @Override
    public IVisitorManager getVisitorManager() {
        return this.visitorManager;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return this.raidManager;
    }

    @Override
    public IEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public IStatisticsManager getStatisticsManager() {
        return this.statisticManager;
    }

    @Override
    public IReproductionManager getReproductionManager() {
        return this.reproductionManager;
    }

    @Override
    public IEventDescriptionManager getEventDescriptionManager() {
        return this.eventDescManager;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public TravellingManager getTravellingManager() {
        return this.travellingManager;
    }

    @Override
    public IColonyConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ImmutableList<Player> getVisitingPlayers() {
        return ImmutableList.copyOf(this.visitingPlayers);
    }

    @Override
    public void addVisitingPlayer(Player player) {
        Rank rank = this.getPermissions().getRank(player);
        if (!rank.isColonyManager() && !this.visitingPlayers.contains(player) && this.settingsModule.getSetting(BuildingTownHall.ENTER_LEAVE_MESSAGES).getValue().booleanValue()) {
            this.visitingPlayers.add(player);
            if (!this.getImportantMessageEntityPlayers().contains(player)) {
                MessageUtils.format("com.minecolonies.coremod.enteringcolony", this.getName()).sendTo(player);
            }
            MessageUtils.format("com.minecolonies.coremod.enteringcolonynotify", player.getName()).sendTo(this, true).forManagers();
        }
    }

    @Override
    public void removeVisitingPlayer(Player player) {
        if (this.visitingPlayers.contains(player) && this.settingsModule.getSetting(BuildingTownHall.ENTER_LEAVE_MESSAGES).getValue().booleanValue()) {
            this.visitingPlayers.remove(player);
            if (!this.getImportantMessageEntityPlayers().contains(player)) {
                MessageUtils.format("com.minecolonies.coremod.leavingcolony", this.getName()).sendTo(player);
            }
            MessageUtils.format("com.minecolonies.coremod.leavingcolonynotify", player.getName()).sendTo(this, true).forManagers();
        }
    }

    @Override
    public CompoundTag getColonyTag() {
        try {
            if (this.colonyTag == null || this.isDirty) {
                this.write(new CompoundTag(), (HolderLookup.Provider)this.world.registryAccess());
            }
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong persisting colony: " + this.id, (Throwable)e);
        }
        return this.colonyTag;
    }

    @Override
    public boolean isValidAttackingPlayer(Player player) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            return attackingPlayer.isValidAttack(this);
        }
        return false;
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        return AttackingPlayer.isValidAttack(entity, this);
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen IEntityCitizen, Player player) {
        if (player == null) {
            return;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            if (attackingPlayer.addGuard(IEntityCitizen)) {
                MessageUtils.format("com.minecolonies.coremod.pvp.attack.guardgroupsize", attackingPlayer.getPlayer().getName(), attackingPlayer.getGuards().size()).sendTo(this).forManagers();
            }
            return;
        }
        for (Player visitingPlayer : this.visitingPlayers) {
            if (!visitingPlayer.equals((Object)player)) continue;
            AttackingPlayer attackingPlayer = new AttackingPlayer(visitingPlayer);
            attackingPlayer.addGuard(IEntityCitizen);
            this.attackingPlayers.add(attackingPlayer);
            MessageUtils.format("com.minecolonies.coremod.pvp.attack.start", visitingPlayer.getName()).sendTo(this).forManagers();
        }
    }

    @Override
    public boolean isColonyUnderAttack() {
        return !this.attackingPlayers.isEmpty();
    }

    @Override
    public ChatFormatting getTeamColonyColor() {
        return this.colonyTeamColor;
    }

    @Override
    public BannerPatternLayers getColonyFlag() {
        return this.colonyFlag;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUse = this.world.getGameTime();
        this.markDirty();
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUse;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        if (this.additionalChildTime < amount) {
            return false;
        }
        this.additionalChildTime -= amount;
        return true;
    }

    @Override
    public void updateHasChilds() {
        for (ICitizenData data : this.getCitizenManager().getCitizens()) {
            if (!data.isChild()) continue;
            this.hasChilds = true;
            return;
        }
        this.hasChilds = false;
    }

    @Override
    public void addLoadedChunk(long chunkPos, LevelChunk chunk) {
        if (this.world instanceof ServerLevel && ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).forceLoadColony.get()).booleanValue()) {
            if (this.forceLoadTimer > 0) {
                this.checkChunkAndRegisterTicket(chunkPos, chunk);
            } else if (this.buildingManager.keepChunkColonyLoaded(chunk)) {
                this.pendingChunks.add(chunkPos);
            }
        }
        this.loadedChunks.put(chunkPos, chunkPos);
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
        this.loadedChunks.remove(chunkPos);
        this.pendingToUnloadChunks.remove(chunkPos);
    }

    @Override
    public int getLoadedChunkCount() {
        return this.loadedChunks.size();
    }

    @Override
    public Set<Long> getLoadedChunks() {
        return this.loadedChunks.keySet();
    }

    @Override
    public ColonyState getState() {
        return (ColonyState)this.colonyStateMachine.getState();
    }

    @Override
    public boolean isActive() {
        return this.colonyStateMachine.getState() != ColonyState.INACTIVE;
    }

    @Override
    public boolean isDay() {
        return this.isDay;
    }

    @Override
    public Set<Long> getTicketedChunks() {
        return this.ticketedChunks;
    }

    @Override
    public void setTextureStyle(String style) {
        this.textureStyle = style;
        this.markDirty();
    }

    @Override
    public String getTextureStyleId() {
        return this.textureStyle;
    }

    @Override
    public void setNameStyle(String style) {
        this.nameStyle = style;
        this.markDirty();
    }

    @Override
    public String getNameStyle() {
        return this.nameStyle;
    }

    @Override
    public CitizenNameFile getCitizenNameFile() {
        return CitizenNameListener.nameFileMap.getOrDefault(this.nameStyle, CitizenNameListener.nameFileMap.get("default"));
    }

    public boolean isTicketedChunksDirty() {
        return this.ticketedChunksDirty;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public IQuestManager getQuestManager() {
        return this.questManager;
    }

    @Override
    public ICitizen getCitizen(int id) {
        return this.citizenManager.getCivilian(id);
    }

    public ISettingsModule getSettings() {
        return this.settingsModule;
    }

    public Long2ObjectMap<ChunkClaimData> getClaimData() {
        return this.claimData;
    }

    public IChunkClaimData claimNewChunk(ChunkPos pos) {
        ChunkClaimData chunkClaimData = new ChunkClaimData();
        this.claimData.put(pos.toLong(), (Object)chunkClaimData);
        IColonyManager.getInstance().addNewChunk(this, pos, chunkClaimData);
        this.markDirty();
        return chunkClaimData;
    }

    public void setDimensionId(ResourceKey<Level> dimensionId) {
        this.dimensionId = dimensionId;
    }
}

