/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.CitizenData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class VisitorData
extends CitizenData
implements IVisitorData {
    private static final String TAG_RECRUIT_COST = "rcost";
    private static final String TAG_RECRUIT_COST_QTY = "rcostqty";
    private BlockPos sittingPosition = BlockPos.ZERO;
    private ItemStack recruitCost = ItemStack.EMPTY;

    public VisitorData(int id, IColony colony) {
        super(id, colony);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compoundNBT = super.serializeNBT(provider);
        ItemStack recruitCopy = this.recruitCost.copy();
        recruitCopy.setCount(1);
        compoundNBT.put(TAG_RECRUIT_COST, recruitCopy.saveOptional(provider));
        compoundNBT.putInt(TAG_RECRUIT_COST_QTY, this.recruitCost.getCount());
        BlockPosUtil.write(compoundNBT, "sit", this.sittingPosition);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbtTagCompound) {
        super.deserializeNBT(provider, nbtTagCompound);
        this.sittingPosition = BlockPosUtil.read(nbtTagCompound, "sit");
        this.recruitCost = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTagCompound.getCompound(TAG_RECRUIT_COST));
        this.recruitCost.setCount(nbtTagCompound.getInt(TAG_RECRUIT_COST_QTY));
    }

    @Override
    public void setRecruitCosts(ItemStack item) {
        this.recruitCost = item;
    }

    @Override
    public ItemStack getRecruitCost() {
        return this.recruitCost;
    }

    public static IVisitorData loadVisitorFromNBT(IColony colony, CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        VisitorData data = new VisitorData(nbt.getInt("id"), colony);
        data.deserializeNBT(provider, (Tag)nbt);
        return data;
    }

    @Override
    public void serializeViewNetworkData(@NotNull RegistryFriendlyByteBuf buf) {
        super.serializeViewNetworkData(buf);
        Utils.serializeCodecMess(buf, this.recruitCost);
        buf.writeInt(this.recruitCost.getCount());
    }

    @Override
    public BlockPos getSittingPosition() {
        return this.sittingPosition;
    }

    @Override
    public void setSittingPosition(BlockPos pos) {
        this.sittingPosition = pos;
    }

    @Override
    public void updateEntityIfNecessary() {
        BlockPos spawnPos;
        Entity entity;
        if (this.getEntity().isPresent() && (entity = (Entity)this.getEntity().get()).isAlive() && WorldUtil.isEntityBlockLoaded((LevelAccessor)entity.level(), entity.blockPosition())) {
            return;
        }
        if (this.getLastPosition() != BlockPos.ZERO && this.getLastPosition().getX() != 0 && this.getLastPosition().getZ() != 0 && WorldUtil.isEntityBlockLoaded((LevelAccessor)this.getColony().getWorld(), this.getLastPosition())) {
            this.getColony().getVisitorManager().spawnOrCreateCivilian(this, this.getColony().getWorld(), this.getLastPosition(), true);
        } else if (this.getHomeBuilding() != null && WorldUtil.isEntityBlockLoaded((LevelAccessor)this.getColony().getWorld(), this.getHomeBuilding().getID()) && (spawnPos = BlockPosUtil.findSpawnPosAround(this.getColony().getWorld(), this.getHomeBuilding().getID())) != null) {
            this.getColony().getVisitorManager().spawnOrCreateCivilian(this, this.getColony().getWorld(), spawnPos, true);
        }
    }

    @Override
    public void applyResearchEffects() {
    }
}

