/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules.expedition;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpeditionLog {
    private static final String TAG_STATUS = "status";
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private static final String TAG_STATS = "stats";
    private static final String TAG_EQUIPMENT = "equip";
    private static final String TAG_MOBS = "mobs";
    private static final String TAG_TYPE = "type";
    private static final String TAG_COUNT = "count";
    private static final String TAG_LOOT = "loot";
    private Status status = Status.NONE;
    private int id;
    private String name;
    private Map<StatType, Double> stats = new HashMap<StatType, Double>();
    private List<ItemStack> equipment = new ArrayList<ItemStack>();
    private Map<EntityType<?>, Integer> mobs = new HashMap();
    private Map<ItemStorage, ItemStorage> loot = new HashMap<ItemStorage, ItemStorage>();

    public void reset() {
        this.status = Status.NONE;
        this.id = 0;
        this.name = null;
        this.stats.clear();
        this.equipment = Collections.emptyList();
        this.mobs.clear();
        this.loot.clear();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public double getStat(StatType stat) {
        return this.stats.getOrDefault((Object)stat, 0.0);
    }

    public void setCitizen(@Nullable AbstractEntityCitizen citizen) {
        if (citizen == null) {
            this.id = 0;
            this.name = null;
            this.stats.clear();
        } else {
            this.id = citizen.getId();
            this.name = citizen.getCitizenData().getName();
            this.stats.put(StatType.HEALTH, Double.valueOf(citizen.getHealth()));
            this.stats.put(StatType.SATURATION, citizen.getCitizenData().getSaturation());
        }
    }

    public void setKilled() {
        this.id = 0;
        this.status = Status.KILLED;
    }

    public List<ItemStack> getEquipment() {
        return this.equipment;
    }

    public void setEquipment(@NotNull List<ItemStack> equipment) {
        this.equipment = (List)equipment.stream().map(ItemStack::copy).collect(ImmutableList.toImmutableList());
    }

    public List<Tuple<EntityType<?>, Integer>> getMobs() {
        return (List)this.mobs.entrySet().stream().map(entry -> new Tuple<EntityType, Integer>((EntityType)entry.getKey(), (Integer)entry.getValue())).sorted(Comparator.comparingInt(Tuple::getB).reversed()).collect(ImmutableList.toImmutableList());
    }

    public void addMob(@NotNull EntityType<?> mobType) {
        this.mobs.merge(mobType, 1, Integer::sum);
    }

    public List<ItemStorage> getLoot() {
        return (List)this.loot.keySet().stream().sorted(Comparator.comparing(ItemStorage::getAmount).reversed()).collect(ImmutableList.toImmutableList());
    }

    public void addLoot(@NotNull List<ItemStack> loot) {
        for (ItemStack stack : loot) {
            ItemStorage storage = new ItemStorage(stack);
            this.loot.merge(storage, storage, (o, n) -> {
                o.setAmount(o.getAmount() + n.getAmount());
                return o;
            });
        }
    }

    public void serializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        compound.putString(TAG_STATUS, this.status.name());
        compound.putInt(TAG_ID, this.id);
        compound.putString(TAG_NAME, this.name == null ? "" : this.name);
        CompoundTag stats = new CompoundTag();
        for (Map.Entry<StatType, Double> entry : this.stats.entrySet()) {
            stats.putDouble(entry.getKey().name().toLowerCase(Locale.US), entry.getValue().doubleValue());
        }
        compound.put(TAG_STATS, (Tag)stats);
        ListTag equipment = new ListTag();
        for (ItemStack itemStack : this.equipment) {
            equipment.add((Object)itemStack.saveOptional(provider));
        }
        compound.put(TAG_EQUIPMENT, (Tag)equipment);
        ListTag listTag = new ListTag();
        for (Map.Entry<EntityType<?>, Integer> entry : this.mobs.entrySet()) {
            CompoundTag mob = new CompoundTag();
            mob.putString(TAG_TYPE, BuiltInRegistries.ENTITY_TYPE.getKey(entry.getKey()).toString());
            mob.putInt(TAG_COUNT, entry.getValue().intValue());
            listTag.add((Object)mob);
        }
        compound.put(TAG_MOBS, (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (ItemStorage storage : this.loot.values()) {
            listTag2.add((Object)StandardFactoryController.getInstance().serializeTag(provider, storage));
        }
        compound.put(TAG_LOOT, (Tag)listTag2);
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        this.status = (Status)((Object)Enums.getIfPresent(Status.class, (String)compound.getString(TAG_STATUS)).or((Object)Status.NONE));
        this.id = compound.getInt(TAG_ID);
        this.name = compound.getString(TAG_NAME);
        if (this.name.isEmpty()) {
            this.name = null;
        }
        this.stats.clear();
        CompoundTag stats = compound.getCompound(TAG_STATS);
        for (StatType stat : StatType.values()) {
            String key = stat.name().toLowerCase(Locale.US);
            if (!stats.contains(key)) continue;
            this.stats.put(stat, stats.getDouble(key));
        }
        this.equipment.clear();
        ListTag equipment = compound.getList(TAG_EQUIPMENT, 10);
        for (int i = 0; i < equipment.size(); ++i) {
            this.equipment.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)equipment.getCompound(i)));
        }
        this.mobs.clear();
        ListTag mobs = compound.getList(TAG_MOBS, 10);
        for (int i = 0; i < mobs.size(); ++i) {
            CompoundTag mob = mobs.getCompound(i);
            ResourceLocation type = ResourceLocation.parse((String)mob.getString(TAG_TYPE));
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(type);
            if (entityType == null) continue;
            this.mobs.put(entityType, mob.getInt(TAG_COUNT));
        }
        this.loot.clear();
        ListTag loot = compound.getList(TAG_LOOT, 10);
        for (int i = 0; i < loot.size(); ++i) {
            ItemStorage storage = (ItemStorage)StandardFactoryController.getInstance().deserializeTag(provider, loot.getCompound(i));
            this.loot.put(storage, storage);
        }
    }

    public void serialize(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.status.ordinal());
        buf.writeVarInt(this.id);
        buf.writeUtf(this.name == null ? "" : this.name);
        for (StatType stat : StatType.values()) {
            buf.writeDouble(this.stats.getOrDefault((Object)stat, 0.0).doubleValue());
        }
        buf.writeVarInt(this.equipment.size());
        for (ItemStack itemStack : this.equipment) {
            Utils.serializeCodecMess(buf, itemStack);
        }
        buf.writeVarInt(this.mobs.size());
        for (Map.Entry entry : this.mobs.entrySet()) {
            buf.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getIdOrThrow(arg_0), (Object)((EntityType)entry.getKey()));
            buf.writeVarInt(((Integer)entry.getValue()).intValue());
        }
        buf.writeVarInt(this.loot.size());
        for (ItemStorage itemStorage : this.loot.values()) {
            StandardFactoryController.getInstance().serialize(buf, itemStorage);
        }
    }

    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        int size;
        this.status = Status.values()[buf.readVarInt()];
        this.id = buf.readVarInt();
        this.name = buf.readUtf();
        if (this.name.isEmpty()) {
            this.name = null;
        }
        this.stats.clear();
        for (StatType stat : StatType.values()) {
            this.stats.put(stat, buf.readDouble());
        }
        this.equipment.clear();
        for (size = buf.readVarInt(); size > 0; --size) {
            this.equipment.add(Utils.deserializeCodecMess(buf));
        }
        this.mobs.clear();
        for (size = buf.readVarInt(); size > 0; --size) {
            EntityType entityType = (EntityType)buf.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).byIdOrThrow(arg_0));
            int count = buf.readVarInt();
            if (entityType == null) continue;
            this.mobs.put(entityType, count);
        }
        this.loot.clear();
        for (size = buf.readVarInt(); size > 0; --size) {
            ItemStorage storage = (ItemStorage)StandardFactoryController.getInstance().deserialize(buf);
            this.loot.put(storage, storage);
        }
    }

    public static enum Status {
        NONE,
        STARTING,
        IN_PROGRESS,
        RETURNING_HOME,
        COMPLETED,
        KILLED;

    }

    public static enum StatType {
        HEALTH,
        SATURATION;

    }
}

