/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class RecipeStorageFactory
implements IRecipeStorageFactory {
    private static final String TAG_GRID = "grid";
    private static final String BLOCK_TAG = "block";
    private static final String INPUT_TAG = "input";
    private static final String ALTOUTPUT_TAG = "alternate-output";
    private static final String SECOUTPUT_TAG = "secondary-output";
    private static final String SOURCE_TAG = "source";
    private static final String TYPE_TAG = "type";
    private static final String LOOT_TAG = "loot-table";
    private static final String TOOL_TAG = "tool";

    @Override
    @NotNull
    public TypeToken<RecipeStorage> getFactoryOutputType() {
        return TypeConstants.RECIPE;
    }

    @Override
    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return TypeConstants.ITOKEN;
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull RecipeStorage recipeStorage) {
        CompoundTag compound = new CompoundTag();
        @NotNull ListTag inputTagList = new ListTag();
        for (ItemStorage itemStorage : recipeStorage.getInput()) {
            @NotNull CompoundTag neededRes = StandardFactoryController.getInstance().serializeTag(provider, itemStorage);
            inputTagList.add((Object)neededRes);
        }
        compound.put(INPUT_TAG, (Tag)inputTagList);
        compound.put("stack", recipeStorage.getPrimaryOutput().saveOptional(provider));
        if (recipeStorage.getIntermediate() != null) {
            compound.put(BLOCK_TAG, (Tag)NbtUtils.writeBlockState((BlockState)recipeStorage.getIntermediate().defaultBlockState()));
        }
        compound.putInt(TAG_GRID, recipeStorage.getGridSize());
        compound.put("Token", (Tag)StandardFactoryController.getInstance().serializeTag(provider, recipeStorage.getToken()));
        if (recipeStorage.getRecipeSource() != null) {
            compound.putString(SOURCE_TAG, recipeStorage.getRecipeSource().toString());
        }
        compound.putString(TYPE_TAG, recipeStorage.getRecipeType().getId().toString());
        @NotNull ListTag altOutputTagList = new ListTag();
        for (ItemStack stack : recipeStorage.getAlternateOutputs()) {
            altOutputTagList.add((Object)stack.saveOptional(provider));
        }
        compound.put(ALTOUTPUT_TAG, (Tag)altOutputTagList);
        @NotNull ListTag listTag = new ListTag();
        for (ItemStack stack : recipeStorage.getCraftingToolsAndSecondaryOutputs()) {
            listTag.add((Object)stack.saveOptional(provider));
        }
        compound.put(SECOUTPUT_TAG, (Tag)listTag);
        if (recipeStorage.getLootTable() != null) {
            compound.putString(LOOT_TAG, recipeStorage.getLootTable().location().toString());
        }
        compound.putString(TOOL_TAG, recipeStorage.getRequiredTool().getRegistryName().toString());
        return compound;
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        ListTag inputTagList = nbt.getList(INPUT_TAG, 10);
        for (int i = 0; i < inputTagList.size(); ++i) {
            CompoundTag inputTag = inputTagList.getCompound(i);
            if (inputTag.contains("NType") || inputTag.contains("Type")) {
                input.add((ItemStorage)StandardFactoryController.getInstance().deserializeTag(provider, inputTag));
                continue;
            }
            ItemStorage newItem = new ItemStorage(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)inputTag.getCompound("stack")));
            input.add(newItem);
        }
        ItemStack primaryOutput = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("stack"));
        Block intermediate = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nbt.getCompound(BLOCK_TAG)).getBlock();
        int gridSize = nbt.getInt(TAG_GRID);
        IToken token = (IToken)StandardFactoryController.getInstance().deserializeTag(provider, nbt.getCompound("Token"));
        ResourceLocation source = nbt.contains(SOURCE_TAG) ? ResourceLocation.parse((String)nbt.getString(SOURCE_TAG)) : null;
        ResourceLocation type = nbt.contains(TYPE_TAG) ? ResourceLocation.parse((String)nbt.getString(TYPE_TAG).toLowerCase()) : ModRecipeTypes.CLASSIC_ID;
        ListTag altOutputTagList = nbt.getList(ALTOUTPUT_TAG, 10);
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < altOutputTagList.size(); ++i) {
            CompoundTag altOutputTag = altOutputTagList.getCompound(i);
            altOutputs.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)altOutputTag));
        }
        ListTag secOutputTagList = nbt.getList(SECOUTPUT_TAG, 10);
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < secOutputTagList.size(); ++i) {
            CompoundTag secOutputTag = secOutputTagList.getCompound(i);
            secOutputs.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)secOutputTag));
        }
        ResourceKey lootTable = nbt.contains(LOOT_TAG) ? ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)nbt.getString(LOOT_TAG))) : null;
        EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.getRegistry().get(EquipmentTypeEntry.parseResourceLocation(nbt.getString(TOOL_TAG)));
        return RecipeStorage.builder().withToken(token).withInputs(input).withGridSize(gridSize).withPrimaryOutput(primaryOutput).withIntermediate(intermediate).withRecipeId(source).withRecipeType(type).withAlternateOutputs(altOutputs).withSecondaryOutputs(secOutputs).withLootTable((ResourceKey<LootTable>)lootTable).withRequiredTool(requiredTool).build();
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, RecipeStorage input, RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeVarInt(input.getInput().size());
        input.getInput().forEach(stack -> StandardFactoryController.getInstance().serialize(packetBuffer, stack));
        Utils.serializeCodecMess(packetBuffer, input.getPrimaryOutput());
        packetBuffer.writeBoolean(input.getIntermediate() != null);
        if (input.getIntermediate() != null) {
            packetBuffer.writeVarInt(Block.getId((BlockState)input.getIntermediate().defaultBlockState()));
        }
        packetBuffer.writeVarInt(input.getGridSize());
        packetBuffer.writeResourceLocation(input.getRecipeType().getId());
        packetBuffer.writeVarInt(input.getAlternateOutputs().size());
        input.getAlternateOutputs().forEach(stack -> Utils.serializeCodecMess(packetBuffer, stack));
        packetBuffer.writeVarInt(input.getCraftingToolsAndSecondaryOutputs().size());
        input.getCraftingToolsAndSecondaryOutputs().forEach(stack -> Utils.serializeCodecMess(packetBuffer, stack));
        packetBuffer.writeResourceLocation(input.getRequiredTool().getRegistryName());
        packetBuffer.writeBoolean(input.getLootTable() != null);
        if (input.getLootTable() != null) {
            packetBuffer.writeResourceKey(input.getLootTable());
        }
        packetBuffer.writeBoolean(input.getRecipeSource() != null);
        if (input.getRecipeSource() != null) {
            packetBuffer.writeResourceLocation(input.getRecipeSource());
        }
        controller.serialize(packetBuffer, input.getToken());
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        int inputSize = buffer.readVarInt();
        for (int i = 0; i < inputSize; ++i) {
            input.add((ItemStorage)StandardFactoryController.getInstance().deserialize(buffer));
        }
        ItemStack primaryOutput = Utils.deserializeCodecMess(buffer);
        Block intermediate = buffer.readBoolean() ? Block.stateById((int)buffer.readVarInt()).getBlock() : Blocks.AIR;
        int gridSize = buffer.readVarInt();
        ResourceLocation type = buffer.readResourceLocation();
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        int altOutputSize = buffer.readVarInt();
        for (int i = 0; i < altOutputSize; ++i) {
            altOutputs.add(Utils.deserializeCodecMess(buffer));
        }
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        int secOutputSize = buffer.readVarInt();
        for (int i = 0; i < secOutputSize; ++i) {
            secOutputs.add(Utils.deserializeCodecMess(buffer));
        }
        ResourceLocation resLoc = EquipmentTypeEntry.parseResourceLocation(buffer.readResourceLocation());
        EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.getRegistry().get(resLoc);
        ResourceKey lootTable = null;
        if (buffer.readBoolean()) {
            lootTable = buffer.readResourceKey(Registries.LOOT_TABLE);
        }
        ResourceLocation source = null;
        if (buffer.readBoolean()) {
            source = buffer.readResourceLocation();
        }
        IToken token = (IToken)controller.deserialize(buffer);
        return RecipeStorage.builder().withToken(token).withInputs(input).withGridSize(gridSize).withPrimaryOutput(primaryOutput).withIntermediate(intermediate).withRecipeId(source).withRecipeType(type).withAlternateOutputs(altOutputs).withSecondaryOutputs(secOutputs).withLootTable((ResourceKey<LootTable>)lootTable).withRequiredTool(requiredTool).build();
    }

    @Override
    public short getSerializationId() {
        return 26;
    }
}

