/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.eventhooks.citizenEvents;

import com.minecolonies.core.colony.eventhooks.citizenEvents.AbstractCitizenEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CitizenDiedEvent
extends AbstractCitizenEvent {
    public static final ResourceLocation CITIZEN_DIED_EVENT_ID = new ResourceLocation("minecolonies", "citizen_died");
    private String deathCause;

    public CitizenDiedEvent() {
    }

    public CitizenDiedEvent(BlockPos eventPos, String citizenName, String deathCause) {
        super(eventPos, citizenName);
        this.deathCause = deathCause;
    }

    @Override
    public ResourceLocation getEventTypeId() {
        return CITIZEN_DIED_EVENT_ID;
    }

    @Override
    public String getName() {
        return "Citizen Died";
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putString("deathCause", this.deathCause);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.deathCause = compound.getString("deathCause");
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        super.serialize(buf);
        buf.writeUtf(this.deathCause);
    }

    @Override
    public void deserialize(RegistryFriendlyByteBuf buf) {
        super.deserialize(buf);
        this.deathCause = buf.readUtf();
    }

    public String getDeathCause() {
        return this.deathCause;
    }

    public void setDeathCause(String deathCause) {
        this.deathCause = deathCause;
    }

    public static CitizenDiedEvent loadFromNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        CitizenDiedEvent deathEvent = new CitizenDiedEvent();
        deathEvent.deserializeNBT(provider, compound);
        return deathEvent;
    }

    public static CitizenDiedEvent loadFromFriendlyByteBuf(@NotNull RegistryFriendlyByteBuf buf) {
        CitizenDiedEvent deathEvent = new CitizenDiedEvent();
        deathEvent.deserialize(buf);
        return deathEvent;
    }
}

