/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractCraftingProductionResolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicWorkerCraftingProductionResolver
extends AbstractCraftingProductionResolver<PublicCrafting> {
    public PublicWorkerCraftingProductionResolver(@NotNull ILocation location, @NotNull IToken<?> token, @NotNull JobEntry jobEntry) {
        super(location, token, jobEntry, PublicCrafting.class);
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request) {
        if (!manager.getColony().getWorld().isClientSide) {
            Colony colony = (Colony)manager.getColony();
            this.removeRequestFromTaskList(request, colony);
        }
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> completedRequest) {
        IColony colony = manager.getColony();
        if (colony instanceof Colony || !completedRequest.hasParent()) {
            this.removeRequestFromTaskList(completedRequest, colony);
            IRequest<?> parentRequest = manager.getRequestForToken((IToken<?>)completedRequest.getParent());
            IRequester parentRequestRequester = parentRequest.getRequester();
            if (parentRequestRequester.getLocation().equals(this.getLocation())) {
                return null;
            }
            ArrayList deliveries = Lists.newArrayList();
            parentRequest.addDelivery((List<ItemStack>)completedRequest.getDeliveries());
            completedRequest.getDeliveries().forEach(itemStack -> {
                Delivery delivery = new Delivery(this.getLocation(), parentRequestRequester.getLocation(), (ItemStack)itemStack, AbstractDeliverymanRequestable.getDefaultDeliveryPriority(true));
                IToken<?> requestToken = manager.createRequest(this, delivery);
                deliveries.add(manager.getRequestForToken(requestToken));
            });
            return deliveries;
        }
        return null;
    }

    private void removeRequestFromTaskList(@NotNull IRequest<? extends PublicCrafting> completedRequest, IColony colony) {
        ICitizenData holdingCrafter = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() instanceof AbstractJobCrafter && (((AbstractJobCrafter)c.getJob()).getTaskQueue().contains(completedRequest.getId()) || ((AbstractJobCrafter)c.getJob()).getAssignedTasks().contains(completedRequest.getId()))).findFirst().orElse(null);
        if (holdingCrafter != null) {
            AbstractJobCrafter job = (AbstractJobCrafter)holdingCrafter.getJob();
            job.onTaskDeletion((IToken<?>)completedRequest.getId());
        }
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        IRequester requester = manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation());
        if (requester instanceof IBuildingView) {
            IBuildingView bwv = (IBuildingView)requester;
            return Component.translatableEscape((String)bwv.getModuleViewMatching(WorkerBuildingModuleView.class, m -> m.getJobEntry() == this.getJobEntry()).getJobDisplayName(), (Object[])new Object[0]);
        }
        if (requester instanceof IBuilding) {
            IBuilding building = (IBuilding)requester;
            return Component.translatableEscape((String)((WorkerBuildingModule)building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobEntry())).getJobDisplayName(), (Object[])new Object[0]);
        }
        return super.getRequesterDisplayName(manager, request);
    }

    @Override
    protected boolean canBuildingCraftStack(@NotNull IRequestManager manager, @NotNull AbstractBuilding building, @NotNull ItemStack stack) {
        if (manager.getColony().getWorld().isClientSide) {
            return false;
        }
        return ((CraftingWorkerBuildingModule)building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobEntry())).getAssignedCitizen().stream().anyMatch(c -> c.getJob() instanceof AbstractJobCrafter);
    }

    @Override
    protected void onAssignedToThisResolverForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request, boolean simulation, @NotNull AbstractBuilding building) {
        if (manager.getColony().getWorld().isClientSide) {
            return;
        }
        ICitizenData freeCrafter = ((CraftingWorkerBuildingModule)building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobEntry())).getAssignedCitizen().stream().filter(c -> c.getJob() instanceof AbstractJobCrafter).min(Comparator.comparing(c -> ((AbstractJobCrafter)c.getJob()).getTaskQueue().size() + ((AbstractJobCrafter)c.getJob()).getAssignedTasks().size())).orElse(null);
        if (freeCrafter == null) {
            this.onAssignedRequestBeingCancelled(manager, request);
            return;
        }
        AbstractJobCrafter job = (AbstractJobCrafter)freeCrafter.getJob();
        job.onTaskBeingScheduled((IToken<?>)request.getId());
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request, @NotNull AbstractBuilding building) {
        if (manager.getColony().getWorld().isClientSide) {
            return;
        }
        ICitizenData freeCrafter = ((CraftingWorkerBuildingModule)building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobEntry())).getAssignedCitizen().stream().filter(c -> c.getJob() instanceof AbstractJobCrafter && ((AbstractJobCrafter)c.getJob()).getAssignedTasks().contains(request.getId())).findFirst().orElse(null);
        if (freeCrafter == null) {
            this.onAssignedRequestBeingCancelled(manager, request);
            return;
        }
        AbstractJobCrafter job = (AbstractJobCrafter)freeCrafter.getJob();
        job.onTaskBeingResolved((IToken<?>)request.getId());
    }
}

