/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.ConstructionTapeHelper;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WorkOrderPlantationField
extends AbstractWorkOrder {
    public WorkOrderPlantationField() {
    }

    private WorkOrderPlantationField(String packName, String path, String translationKey, WorkOrderType workOrderType, BlockPos location, RotationMirror rotationMirror, int currentLevel, int targetLevel) {
        super(packName, path, translationKey, workOrderType, location, rotationMirror, currentLevel, targetLevel);
    }

    public static WorkOrderPlantationField create(@NotNull WorkOrderType type, String packName, String path, String translationKey, BlockPos location, RotationMirror rotationMirror, int currentLevel) {
        int targetLevel = 1;
        if (type == WorkOrderType.REMOVE) {
            targetLevel = 0;
        }
        return new WorkOrderPlantationField(packName, path, translationKey, type, location, rotationMirror, currentLevel, targetLevel);
    }

    @Override
    public boolean canBuild(IBuilding building) {
        return building instanceof BuildingBuilder;
    }

    @Override
    public boolean canBuildIgnoringDistance(@NotNull IBuilding building, BlockPos position, int level) {
        return this.canBuild(building);
    }

    @Override
    public boolean isValid(IColony colony) {
        return super.isValid(colony) && this.getStructurePath() != null && !this.getStructurePath().isEmpty();
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
        super.onAdded(colony, readingFromNbt);
        if (!readingFromNbt && colony != null && colony.getWorld() != null) {
            ConstructionTapeHelper.placeConstructionTape(this, colony.getWorld(), colony);
            MessageUtils.format("com.minecolonies.coremod.decoorderadded", colony.getName()).sendTo(colony).forManagers();
        }
    }

    @Override
    public void onRemoved(IColony colony) {
        super.onRemoved(colony);
        ConstructionTapeHelper.removeConstructionTape(this, colony.getWorld());
    }
}

