/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandChangeOwner
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        GameProfile profile;
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        try {
            profile = GameProfileArgument.getGameProfiles(context, (String)"playername").stream().findFirst().orElse(null);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(profile.getId());
        if (player == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.playernotfound", (Object[])new Object[]{profile.getName()}), true);
            return 0;
        }
        colony.getPermissions().setOwner((Player)player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.ownerchange.success", (Object[])new Object[]{profile.getName(), colony.getName()}), true);
        return 1;
    }

    @Override
    public String getName() {
        return "setowner";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("playername", GameProfileArgument.gameProfile()).executes(this::checkPreConditionAndExecute)));
    }
}

