/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.util.BackUpHelper;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandDeleteColony
implements IMCColonyOfficerCommand {
    private static final String COMMAND_NAME = "delete";
    private static final String DELETE_BUILDINGS_ARG = "keep / delete buildings";
    private static final String CONFIRM_ARG = "confirm";

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).executes(this::executeGuidedBuildingAsk)).then(((RequiredArgumentBuilder)IMCCommand.newArgument(DELETE_BUILDINGS_ARG, DeleteBuildingsArgumentType.argument()).executes(this::executeGuidedConfirm)).then(IMCCommand.newArgument(CONFIRM_ARG, BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }

    private ClickEvent createClickEvent(CommandContext<CommandSourceStack> context, boolean confirm) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + context.getInput() + " " + confirm);
    }

    private Component braceButtonComponent(Component button) {
        return Component.literal((String)"[").append(button).append("]");
    }

    private int executeGuidedBuildingAsk(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        Style keepButtonStyle = Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_GREEN).withClickEvent(this.createClickEvent(context, false));
        Style deleteButtonStyle = Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_RED).withClickEvent(this.createClickEvent(context, true));
        Component keepButton = this.braceButtonComponent((Component)Component.translatableEscape((String)"com.minecolonies.command.delete.confirm.building.keep", (Object[])new Object[0]).setStyle(keepButtonStyle));
        Component deleteButton = this.braceButtonComponent((Component)Component.translatableEscape((String)"com.minecolonies.command.delete.confirm.building.delete", (Object[])new Object[0]).setStyle(deleteButtonStyle));
        TranslatableContents contents = new TranslatableContents("com.minecolonies.command.delete.confirm.building", null, (Object[])new Component[]{keepButton, deleteButton});
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> MutableComponent.create((ComponentContents)contents).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)), true);
        return 1;
    }

    private int executeGuidedConfirm(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        Style buttonStyle = Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_RED).withClickEvent(this.createClickEvent(context, true));
        Component confirmButton = this.braceButtonComponent((Component)Component.translatableEscape((String)"com.minecolonies.command.delete.confirm.final.here", (Object[])new Object[0]).setStyle(buttonStyle));
        MutableComponent deleteBuildingsComponent = Component.empty();
        if (BoolArgumentType.getBool(context, (String)DELETE_BUILDINGS_ARG)) {
            deleteBuildingsComponent = Component.translatableEscape((String)"com.minecolonies.command.delete.confirm.final.building", (Object[])new Object[0]).append(" ").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        }
        TranslatableContents contents = new TranslatableContents("com.minecolonies.command.delete.confirm.final", null, (Object[])new Component[]{deleteBuildingsComponent, confirmButton});
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> MutableComponent.create((ComponentContents)contents).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)), true);
        return 1;
    }

    @Override
    public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).hasPermission(4) && !((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).canPlayerUseDeleteColonyCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.notenabledinconfig", (Object[])new Object[0]), true);
            return false;
        }
        return IMCColonyOfficerCommand.super.checkPreCondition(context);
    }

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        boolean deleteBuildings = BoolArgumentType.getBool(context, (String)DELETE_BUILDINGS_ARG);
        boolean confirmation = BoolArgumentType.getBool(context, (String)CONFIRM_ARG);
        if (!confirmation) {
            return 1;
        }
        BackUpHelper.backupColonyData((HolderLookup.Provider)colony.getWorld().registryAccess());
        IColonyManager.getInstance().deleteColonyByDimension(colony.getID(), deleteBuildings, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.delete.success", (Object[])new Object[]{colony.getName()}), true);
        return 1;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public static class DeleteBuildingsArgumentType
    implements ArgumentType<Boolean> {
        public static DeleteBuildingsArgumentType argument() {
            return new DeleteBuildingsArgumentType();
        }

        public Boolean parse(StringReader reader) throws CommandSyntaxException {
            return BoolArgumentType.bool().parse(reader);
        }

        public CompletableFuture<Suggestions> listSuggestions(CommandContext context, SuggestionsBuilder builder) {
            if ("true".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("true", (Message)Component.translatableEscape((String)"com.minecolonies.command.delete.confirm.suggest.delete", (Object[])new Object[0]));
            }
            if ("false".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("false", (Message)Component.translatableEscape((String)"com.minecolonies.command.delete.confirm.suggest.keep", (Object[])new Object[0]));
            }
            return builder.buildFuture();
        }

        static {
            ArgumentTypeInfos.registerByClass(DeleteBuildingsArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(DeleteBuildingsArgumentType::argument));
        }
    }
}

