/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.util.TeleportHelper;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandTeleport
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!IMCCommand.isPlayerOped((Player)sender) && !((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).canPlayerUseColonyTPCommand.get()).booleanValue()) {
            MessageUtils.format("com.minecolonies.command.notenabledinconfig", new Object[0]).sendTo((Player)sender);
            return 0;
        }
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        ServerPlayer player = (ServerPlayer)sender;
        TeleportHelper.colonyTeleport(player, colony);
        return 1;
    }

    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).executes(this::checkPreConditionAndExecute));
    }
}

