/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandWhereAmI
implements IMCCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        BlockPos playerPos = sender.blockPosition();
        IColony colony = IColonyManager.getInstance().getClosestColony(sender.getCommandSenderWorld(), playerPos);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.whereami.nocolony", new Object[0]).sendTo((Player)sender);
            return 0;
        }
        BlockPos center = colony.getCenter();
        double distance = BlockPosUtil.getDistance2D(center, new BlockPos(playerPos.getX(), center.getY(), playerPos.getZ()));
        if (!IColonyManager.getInstance().isCoordinateInAnyColony(sender.getCommandSenderWorld(), playerPos)) {
            MessageUtils.format("com.minecolonies.command.whereami.colonyclose", distance).sendTo((Player)sender);
            return 0;
        }
        String colonyName = colony.getName();
        String id = Integer.toString(colony.getID());
        MessageUtils.format("com.minecolonies.command.whereami.incolony", colonyName, id, distance).sendTo((Player)sender);
        return 0;
    }

    @Override
    public String getName() {
        return "whereami";
    }
}

