/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.colony.crafting.ToolUsage;
import com.minecolonies.core.colony.crafting.ToolsAnalyzer;
import com.minecolonies.core.compatibility.jei.ModRecipeTypes;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ToolRecipeCategory
extends AbstractRecipeCategory<ToolUsage> {
    private static final int WIDTH = 180;
    private static final int HEIGHT = 44;
    private static final int SLOT_X = 70;
    private static final int SLOT_Y = 8;

    public ToolRecipeCategory(@NotNull IGuiHelper guiHelper) {
        super(ModRecipeTypes.TOOLS, (Component)Component.translatableEscape((String)"com.minecolonies.coremod.jei.tools", (Object[])new Object[0]), guiHelper.createDrawableItemLike((ItemLike)ModItems.plateArmorChest), 180, 44);
    }

    @NotNull
    public static List<ToolUsage> findRecipes(Level level) {
        return ToolsAnalyzer.findTools(level);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ToolUsage recipe, @NotNull IFocusGroup focuses) {
        int x = 70;
        int y = 8;
        for (int i = 0; i <= 5; ++i) {
            ((IRecipeSlotBuilder)builder.addInputSlot(x, y).setSlotName("L" + i).addItemStacks(recipe.toolLevels().get(i))).setStandardSlotBackground();
            ((IRecipeSlotBuilder)builder.addInputSlot(x, y + 18).setSlotName("L" + i + "e").addItemStacks(recipe.enchantedToolLevels().get(i))).setStandardSlotBackground();
            x += 18;
        }
    }

    public void draw(@NotNull ToolUsage recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        int scale = 2;
        stack.pose().pushPose();
        stack.pose().scale(0.5f, 0.5f, 1.0f);
        int x = 70;
        for (int i = 0; i <= 5; ++i) {
            MutableComponent text = Component.translatableEscape((String)"com.minecolonies.coremod.jei.onelevelrestriction", (Object[])new Object[]{i});
            stack.drawString(mc.font, (Component)text, (x + (18 - mc.font.width((FormattedText)text) / 2) / 2) * 2, 2, 0, false);
            x += 18;
        }
        stack.pose().popPose();
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull ToolUsage recipe, @NotNull IFocusGroup focuses) {
        ((ITextWidget)builder.addText((FormattedText)recipe.tool().getDisplayName(), 64, this.getHeight() - 8).setPosition(2, 7)).setTextAlignment(VerticalAlignment.CENTER);
    }
}

