/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.journeymap;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.compatibility.journeymap.JourneymapOptions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Displayable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Journeymap {
    private static Journeymap INSTANCE;
    private IClientAPI jmap;
    private JourneymapOptions options;

    public Journeymap(IClientAPI jmap) {
        this.jmap = jmap;
        INSTANCE = this;
    }

    @NotNull
    public static Optional<Journeymap> getInstance() {
        return Optional.ofNullable(INSTANCE);
    }

    @NotNull
    public IClientAPI getApi() {
        return this.jmap;
    }

    @NotNull
    public Optional<JourneymapOptions> getOptions() {
        return Optional.ofNullable(this.options);
    }

    public void setOptions(JourneymapOptions options) {
        this.options = options;
    }

    public void show(@NotNull Displayable displayable) {
        try {
            this.getApi().show(displayable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Path getDataPath(ResourceKey<Level> dimension) {
        String name = dimension.location().getPath();
        return this.jmap.getDataPath("minecolonies").toPath().resolve(name);
    }

    public <T> Optional<T> loadData(@NotNull Path filePath, @NotNull String description, @NotNull Codec<T> codec) {
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                JsonElement json;
                try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(filePath));){
                    json = Streams.parse((JsonReader)reader);
                }
                return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> Log.getLogger().error("Failed to load " + description + " from " + String.valueOf(filePath)));
            }
            catch (Exception ex) {
                Log.getLogger().error("Failed to read " + description + " from " + String.valueOf(filePath), (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    public <T> boolean saveData(@NotNull Path filePath, @NotNull String description, @NotNull Codec<T> codec, @NotNull T value) {
        block7: {
            boolean bl;
            JsonElement json = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).resultOrPartial(error -> Log.getLogger().error("Failed to save " + description + ": " + error)).orElse(null);
            if (json == null) break block7;
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(filePath, new OpenOption[0]));
            try {
                Streams.write((JsonElement)json, (JsonWriter)writer);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    Log.getLogger().error("Failed to write " + description + " to " + String.valueOf(filePath), (Throwable)ex);
                }
            }
            writer.close();
            return bl;
        }
        return false;
    }
}

