/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBeekeeper;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobBeekeeper;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkBeekeeper
extends AbstractEntityAIInteract<JobBeekeeper, BuildingBeekeeper> {
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    private static final int BEES_PER_LEVEL = 3;
    private static final int NUM_OF_FLOWERS_TO_BREED = 2;
    private static final int NUM_OF_WANTED_FLOWERS = 16;
    private static final double EXP_PER_HARVEST = 5.0;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int HIVE_BEE_RADIUS = 22;
    private static final int DECIDING_DELAY = 40;
    private static final int NO_ANIMALS_DELAY = 100;
    private static final int NO_HIVES_DELAY = 100;
    private static final int NO_FLOWERS_DELAY = 100;
    private static final int BREEDING_DELAY = 40;
    private boolean lastHarvestedBottle = false;

    public EntityAIWorkBeekeeper(@NotNull JobBeekeeper job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForHerding, 1), new AITarget<Object>(AIWorkerState.DECIDE, this::decideWhatToDo, 1), new AITarget<Object>(AIWorkerState.HERDER_BREED, this::breedAnimals, 1), new AITarget<Object>(AIWorkerState.BEEKEEPER_HARVEST, this::harvestHoney, 20));
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 5;
    }

    private boolean hasMaxAnimals(List<Bee> allBees) {
        int maxAnimals;
        int numOfBeesInHive = this.getBeesInHives();
        int numOfAnimals = allBees.size();
        return numOfAnimals + numOfBeesInHive >= (maxAnimals = ((BuildingBeekeeper)this.building).getBuildingLevel() * 3);
    }

    private int getBeesInHives() {
        return ((BuildingBeekeeper)this.building).getHives().stream().map(arg_0 -> ((ServerLevel)this.world).getBlockEntity(arg_0)).filter(Objects::nonNull).map(BeehiveBlockEntity.class::cast).mapToInt(BeehiveBlockEntity::getOccupantCount).sum();
    }

    private IAIState prepareForHerding() {
        this.setDelay(40);
        if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honey") && this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shears.get())) {
            return this.getState();
        }
        if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honeycomb")) {
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState decideWhatToDo() {
        this.setDelay(40 + (99 / this.getSecondarySkillLevel() - 1));
        Set<BlockPos> hives = ((BuildingBeekeeper)this.building).getHives();
        if (hives.isEmpty()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"entity.beekeeper.messagenohives", (Object[])new Object[0]), ChatPriority.BLOCKING));
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        ItemListModule flowersModule = (ItemListModule)((BuildingBeekeeper)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"));
        if (flowersModule.getList().isEmpty() && ((BoolSetting)((BuildingBeekeeper)this.building).getSetting(BuildingBeekeeper.BREEDING)).getValue().booleanValue()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.beekeeper.noflowers", (Object[])new Object[0]), ChatPriority.BLOCKING));
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        BlockPos hive = this.getHiveToHarvest();
        if (hive != null) {
            return AIWorkerState.BEEKEEPER_HARVEST;
        }
        List<Bee> bees = EntityAIWorkBeekeeper.searchForAnimals((Level)this.world, (BuildingBeekeeper)this.building);
        JobBeekeeper job = this.worker.getCitizenJobHandler().getColonyJob(JobBeekeeper.class);
        if (bees.isEmpty()) {
            if (this.getBeesInHives() <= 0) {
                job.tickNoBees();
                if (job.checkForBeeInteraction()) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"entity.beekeeper.messagenobees", (Object[])new Object[0]), ChatPriority.BLOCKING));
                }
            } else {
                job.resetCounter();
            }
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        job.resetCounter();
        if (this.isReadyForBreeding()) {
            return AIWorkerState.HERDER_BREED;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState breedAnimals() {
        this.setDelay(40);
        List<Bee> animals = EntityAIWorkBeekeeper.searchForAnimals((Level)this.world, (BuildingBeekeeper)this.building);
        Animal animalOne = animals.stream().filter(animal -> !animal.isBaby()).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        Animal animalTwo = animals.stream().filter(animal -> {
            float range = animal.distanceTo((Entity)animalOne);
            boolean isAnimalOne = animalOne.equals(animal);
            return animal.getAge() == 0 && range <= 10.0f && !isAnimalOne;
        }).findAny().orElse(null);
        if (animalTwo == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipBreedItem(InteractionHand.MAIN_HAND)) {
            return AIWorkerState.START_WORKING;
        }
        this.breedTwoAnimals(animalOne, animalTwo);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    private BlockPos getHiveToHarvest() {
        for (BlockPos pos : ((BuildingBeekeeper)this.building).getHives()) {
            BlockState blockState = this.world.getBlockState(pos);
            if (blockState.is(BlockTags.BEEHIVES)) {
                if (BeehiveBlockEntity.getHoneyLevel((BlockState)this.world.getBlockState(pos)) < 5) continue;
                return pos;
            }
            ((BuildingBeekeeper)this.building).removeHive(pos);
        }
        return null;
    }

    private IAIState harvestHoney() {
        if (((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honeycomb") || ((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.both") && this.lastHarvestedBottle ? !this.equipTool(InteractionHand.MAIN_HAND, (EquipmentTypeEntry)ModEquipmentTypes.shears.get()) : !this.equipItem(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
            return AIWorkerState.PREPARING;
        }
        BlockPos hive = this.getHiveToHarvest();
        if (hive == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.walkToWorkPos(hive)) {
            return this.getState();
        }
        this.worker.swing(InteractionHand.MAIN_HAND);
        ItemStack itemStack = this.worker.getMainHandItem();
        if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honey") && ((EquipmentTypeEntry)ModEquipmentTypes.shears.get()).checkIsEquipment(itemStack)) {
            CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            for (ItemStack stackItem : Compatibility.getCombsFromHive(hive, (Level)this.world, this.getHoneycombsPerHarvest())) {
                StatsUtil.trackStatByStack(this.building, "items_collected", stackItem, stackItem.getCount());
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(stackItem, this.worker.getItemHandlerCitizen());
            }
            this.world.setBlockAndUpdate(hive, (BlockState)this.world.getBlockState(hive).setValue((Property)BlockStateProperties.LEVEL_HONEY, (Comparable)Integer.valueOf(0)));
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.lastHarvestedBottle = false;
        } else if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honeycomb") && itemStack.getItem() == Items.GLASS_BOTTLE) {
            int i;
            for (i = 0; i < this.getHoneyBottlesPerHarvest() && !itemStack.isEmpty(); ++i) {
                itemStack.shrink(1);
            }
            ItemStack honeyStack = new ItemStack((ItemLike)Items.HONEY_BOTTLE, i);
            StatsUtil.trackStatByStack(this.building, "items_collected", honeyStack, honeyStack.getCount());
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(honeyStack, this.worker.getItemHandlerCitizen());
            this.world.setBlockAndUpdate(hive, (BlockState)this.world.getBlockState(hive).setValue((Property)BlockStateProperties.LEVEL_HONEY, (Comparable)Integer.valueOf(0)));
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.lastHarvestedBottle = true;
        }
        int dex = this.getPrimarySkillLevel();
        if ((50.0 - (double)dex / 99.0 * 50.0) / 100.0 > this.worker.getRandom().nextDouble()) {
            List bees = ((BeehiveBlockEntity)this.world.getBlockEntity(hive)).releaseAllOccupants(this.world.getBlockState(hive), BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
            bees.stream().filter(entity -> entity instanceof Bee).map(entity -> (Bee)entity).filter(bee -> this.worker.position().distanceToSqr(bee.position()) <= 16.0).forEach(bee -> {
                bee.setRemainingPersistentAngerTime(400 + this.worker.getRandom().nextInt(400));
                bee.setLastHurtByMob((LivingEntity)this.worker);
            });
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    public boolean walkingToAnimal(Animal animal) {
        if (animal != null) {
            return this.walkToWorkPos(animal.blockPosition());
        }
        return true;
    }

    private boolean isReadyForBreeding() {
        boolean canBreed;
        if (!((BoolSetting)((BuildingBeekeeper)this.building).getSetting(BuildingBeekeeper.BREEDING)).getValue().booleanValue()) {
            return false;
        }
        ItemListModule flowersModule = (ItemListModule)((BuildingBeekeeper)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"));
        List<Bee> bees = EntityAIWorkBeekeeper.searchForAnimals((Level)this.world, (BuildingBeekeeper)this.building);
        int breedableAnimals = (int)bees.stream().filter(animal -> animal.getAge() == 0).count();
        boolean bl = canBreed = !this.hasMaxAnimals(bees) && breedableAnimals >= 2;
        if (canBreed) {
            int flowerCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> flowersModule.isItemInList(new ItemStorage((ItemStack)stack))) + InventoryUtils.getCountFromBuilding((IBuilding)this.building, flowersModule.getList());
            if (flowerCount < 2 && !((BuildingBeekeeper)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                this.worker.getCitizenData().createRequestAsync(new StackList(flowersModule.getList().stream().map(ItemStorage::getItemStack).peek(stack -> stack.setCount(16)).collect(Collectors.toList()), "com.minecolonies.coremod.request.flowers", 16, 2));
                return false;
            }
            return flowerCount >= 2;
        }
        return false;
    }

    private void breedTwoAnimals(Animal animalOne, Animal animalTwo) {
        ArrayList<Animal> animalsToBreed = new ArrayList<Animal>();
        animalsToBreed.add(animalOne);
        animalsToBreed.add(animalTwo);
        for (Animal animal : animalsToBreed) {
            if (animal.isInLove() || !this.walkingToAnimal(animal)) continue;
            animal.setInLove(null);
            this.worker.swing(InteractionHand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.worker.getMainHandItem());
        }
        StatsUtil.trackStat(this.building, "breeding_attempts", 1);
    }

    public boolean equipTool(InteractionHand hand, EquipmentTypeEntry toolType) {
        if (this.getToolSlot(toolType) != -1) {
            CitizenItemUtils.setHeldItem(this.worker, hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(EquipmentTypeEntry toolType) {
        int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), toolType, 0, ((BuildingBeekeeper)this.building).getMaxEquipmentLevel());
        if (slot == -1) {
            this.checkForToolOrWeapon(toolType);
        }
        return slot;
    }

    public boolean equipItem(InteractionHand hand, ItemStack itemStack) {
        if (this.checkIfRequestForItemExistOrCreateAsync(itemStack)) {
            CitizenItemUtils.setHeldItem(this.worker, hand, this.getItemSlot(itemStack.getItem()));
            return true;
        }
        return false;
    }

    public boolean equipBreedItem(InteractionHand hand) {
        if (this.checkIfRequestForTagExistOrCreateAsync((TagKey<Item>)ItemTags.FLOWERS, 2)) {
            ItemListModule flowersModule = (ItemListModule)((BuildingBeekeeper)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"));
            CitizenItemUtils.setHeldItem(this.worker, hand, InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), stack -> flowersModule.isItemInList(new ItemStorage((ItemStack)stack))));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), item);
    }

    public static List<Bee> searchForAnimals(Level world, BuildingBeekeeper ownBuilding) {
        if (ownBuilding == null) {
            return new ArrayList<Bee>();
        }
        return ownBuilding.getHives().stream().map(AABB::new).map(aabb -> aabb.inflate(22.0)).map(aabb -> world.getEntitiesOfClass(Bee.class, aabb)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private int getHoneyBottlesPerHarvest() {
        return 1;
    }

    private int getHoneycombsPerHarvest() {
        return 3;
    }

    @Override
    public Class<BuildingBeekeeper> getExpectedBuildingClass() {
        return BuildingBeekeeper.class;
    }
}

