/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockStateUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.MineColonies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree {
    private static final String DYNAMICTREERADIUS = "radius";
    private static final int NUMBER_OF_LEAVES = 3;
    private static final int LEAVES_WIDTH = 4;
    private static final int A_LOT_OF_LUCK = 10000;
    private BlockPos location;
    private BlockPos topLog;
    private LinkedList<BlockPos> woodBlocks = new LinkedList();
    private LinkedList<BlockPos> leaves = new LinkedList();
    private boolean isTree;
    private ItemStack sapling;
    private ArrayList<BlockPos> stumpLocations;
    private Property<?> variant;
    private boolean slimeTree = false;
    private boolean dynamicTree = false;
    private boolean netherTree = false;

    private Tree() {
        this.isTree = true;
    }

    public Tree(@NotNull Level world, @NotNull BlockPos log, @Nullable IColony colony) {
        BlockState block = BlockPosUtil.getBlockState(world, log);
        if (block.is(ModTags.tree) || Compatibility.isSlimeBlock(block.getBlock()) || Compatibility.isDynamicBlock(block.getBlock())) {
            this.isTree = true;
            this.woodBlocks = new LinkedList();
            this.leaves = new LinkedList();
            this.location = log;
            this.topLog = log;
            this.addAndSearch(world, log, colony);
            this.addAndSearch(world);
            this.checkTree(world, this.topLog);
            this.dynamicTree = Compatibility.isDynamicBlock(block.getBlock());
            this.stumpLocations = new ArrayList();
            this.woodBlocks.clear();
            this.slimeTree = Compatibility.isSlimeBlock(block.getBlock());
            this.sapling = this.calcSapling(world);
            if (this.sapling.is(Tags.Items.MUSHROOMS) || this.sapling.is(ModTags.fungi)) {
                this.netherTree = true;
            }
            this.variant = BlockStateUtils.getPropertyByNameFromState(world.getBlockState(this.location), "variant");
        } else {
            this.isTree = false;
        }
    }

    private ItemStack calcSapling(Level world) {
        if (this.topLog == null) {
            return ItemStack.EMPTY;
        }
        BlockPos firstLeaf = this.getFirstLeaf((LevelAccessor)world);
        ItemStack sapling = this.calcSaplingForPos(world, firstLeaf, true);
        if (sapling != null) {
            return sapling;
        }
        for (BlockPos pos : this.leaves) {
            sapling = this.calcSaplingForPos(world, pos, true);
            if (sapling == null) continue;
            return sapling;
        }
        sapling = this.calcSaplingForPos(world, firstLeaf, false);
        if (sapling != null) {
            return sapling;
        }
        return ItemStackUtils.EMPTY;
    }

    private ItemStack calcSaplingForPos(Level world, BlockPos pos, boolean checkFitsBase) {
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (blockState.is(BlockTags.LEAVES) || Compatibility.isDynamicLeaf(block) || blockState.is(ModTags.hugeMushroomBlocks)) {
            NonNullList<ItemStack> list = NonNullList.create();
            if (checkFitsBase && Compatibility.isDynamicLeaf(block) && (!this.isDynamicTree() || !Compatibility.isDynamicFamilyFitting(pos, this.location, (LevelAccessor)world))) {
                return null;
            }
            if (Compatibility.isDynamicLeaf(block)) {
                list = Compatibility.getDropsForDynamicLeaf((LevelAccessor)world, pos, blockState, 10000, block);
            } else {
                list.addAll(Tree.getSaplingsForLeaf((ServerLevel)world, pos));
            }
            for (ItemStack stack : list) {
                if (stack.isEmpty() || !stack.is(ItemTags.SAPLINGS) && !stack.is(Tags.Items.MUSHROOMS)) continue;
                IColonyManager.getInstance().getCompatibilityManager().connectLeafToSapling(block, stack);
                return stack;
            }
        } else if (blockState.is(BlockTags.WART_BLOCKS)) {
            return IColonyManager.getInstance().getCompatibilityManager().getSaplingForLeaf(block);
        }
        return null;
    }

    public static List<ItemStack> getSaplingsForLeaf(ServerLevel world, BlockPos position) {
        NonNullList list = NonNullList.create();
        BlockState state = world.getBlockState(position);
        if (state.is(Blocks.MANGROVE_LEAVES)) {
            list.add((Object)new ItemStack((ItemLike)Items.MANGROVE_PROPAGULE));
            return list;
        }
        for (int i = 1; i < 100; ++i) {
            list.addAll((Collection)state.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.TOOL, (Object)new ItemStack((ItemLike)Items.WOODEN_AXE)).withLuck(100.0f).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)position.getX(), (double)position.getY(), (double)position.getZ()))));
            if (list.isEmpty()) continue;
            for (ItemStack stack : list) {
                if (!stack.is(ItemTags.SAPLINGS) && !stack.is(Tags.Items.MUSHROOMS)) continue;
                return list;
            }
        }
        return list;
    }

    private BlockPos getFirstLeaf(LevelAccessor world) {
        for (int i = 1; i + this.topLog.getY() < world.getMaxBuildHeight() && i < 10; ++i) {
            BlockState blockState = world.getBlockState(this.topLog.offset(0, i, 0));
            if (!blockState.is(BlockTags.LEAVES) && !blockState.is(ModTags.hugeMushroomBlocks)) continue;
            return this.topLog.offset(0, i, 0);
        }
        return this.topLog.offset(0, 1, 0);
    }

    public static boolean checkTree(@NotNull LevelReader world, BlockPos pos, List<ItemStorage> treesToNotCut, int dyntreesize) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!(state.is(ModTags.tree) || Compatibility.isSlimeBlock(block) || Compatibility.isDynamicBlock(block))) {
            return false;
        }
        if (Compatibility.isDynamicBlock(block) && BlockStateUtils.getPropertyByNameFromState(state, DYNAMICTREERADIUS) != null && (Integer)state.getValue(BlockStateUtils.getPropertyByNameFromState(state, DYNAMICTREERADIUS)) < dyntreesize) {
            return false;
        }
        Tuple<BlockPos, BlockPos> baseAndTOp = Tree.getBottomAndTopLog(world, pos, new LinkedList<BlockPos>(), null, null);
        BlockPos basePos = (BlockPos)baseAndTOp.getA();
        return BlockUtils.isAnySolid((BlockState)world.getBlockState(basePos.below())) && world.getBlockState(basePos.below()).getBlock() != Blocks.COBBLESTONE && Tree.hasEnoughLeavesAndIsSupposedToCut(world, (BlockPos)baseAndTOp.getB(), treesToNotCut);
    }

    @NotNull
    private static Tuple<BlockPos, BlockPos> getBottomAndTopLog(@NotNull LevelReader world, @NotNull BlockPos log, @NotNull LinkedList<BlockPos> woodenBlocks, BlockPos bottomLog, BlockPos topLog) {
        BlockPos top;
        BlockPos bottom = bottomLog == null ? log : bottomLog;
        BlockPos blockPos = top = topLog == null ? log : topLog;
        if (woodenBlocks.size() >= (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxTreeSize.get()) {
            return new Tuple((Object)bottom, (Object)top);
        }
        if (log.getY() < bottom.getY()) {
            bottom = log;
        }
        if (log.getY() > top.getY()) {
            top = log;
        }
        woodenBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.offset(x, y, z);
                    BlockState block = world.getBlockState(temp);
                    if (!block.is(ModTags.tree) && !Compatibility.isSlimeBlock(block.getBlock()) && !Compatibility.isDynamicBlock(block.getBlock()) || woodenBlocks.contains(temp)) continue;
                    return Tree.getBottomAndTopLog(world, temp, woodenBlocks, bottom, top);
                }
            }
        }
        return new Tuple((Object)bottom, (Object)top);
    }

    private static boolean hasEnoughLeavesAndIsSupposedToCut(@NotNull LevelReader world, BlockPos pos, List<ItemStorage> treesToNotCut) {
        boolean checkedLeaves = false;
        int leafCount = 0;
        int dynamicBonusY = 0;
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(ModTags.mangroveTree) || Compatibility.isDynamicBlock(blockState.getBlock())) {
            dynamicBonusY = 8;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -3; dy <= 3 + dynamicBonusY; ++dy) {
                    BlockPos leafPos = pos.offset(dx, dy, dz);
                    BlockState block = world.getBlockState(leafPos);
                    if (!block.is(BlockTags.LEAVES) && !block.is(ModTags.hugeMushroomBlocks) && !block.is(BlockTags.WART_BLOCKS)) continue;
                    if (!checkedLeaves && !Tree.supposedToCut(world, treesToNotCut, leafPos)) {
                        return false;
                    }
                    checkedLeaves = true;
                    if (++leafCount < 3 && !Compatibility.isDynamicLeaf(block.getBlock())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean supposedToCut(LevelReader world, List<ItemStorage> treesToNotCut, BlockPos leafPos) {
        BlockState leaf = world.getBlockState(leafPos);
        if (leaf.getOptionalValue((Property)LeavesBlock.PERSISTENT).orElse(false).booleanValue()) {
            return false;
        }
        ItemStack sap = IColonyManager.getInstance().getCompatibilityManager().getSaplingForLeaf(leaf.getBlock());
        if (sap == null) {
            return true;
        }
        for (ItemStorage stack : treesToNotCut) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(sap, stack.getItemStack()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Tree read(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        @NotNull Tree tree = new Tree();
        tree.location = BlockPosUtil.read(compound, "location");
        tree.woodBlocks = new LinkedList();
        ListTag logs = compound.getList("Logs", 10);
        for (int i = 0; i < logs.size(); ++i) {
            tree.woodBlocks.add(BlockPosUtil.readFromListNBT(logs, i));
        }
        tree.stumpLocations = new ArrayList();
        ListTag stumps = compound.getList("Stumps", 10);
        for (int i = 0; i < stumps.size(); ++i) {
            tree.stumpLocations.add(BlockPosUtil.readFromListNBT(stumps, i));
        }
        tree.topLog = BlockPosUtil.read(compound, "topLog");
        tree.slimeTree = compound.getBoolean("slimeTree");
        tree.dynamicTree = compound.getBoolean("dynamicTree");
        if (compound.contains("treesapling")) {
            tree.sapling = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("treesapling"));
        } else {
            tree.isTree = false;
        }
        tree.netherTree = compound.contains("netherTree") ? compound.getBoolean("netherTree") : false;
        if (compound.contains("leaves")) {
            ListTag leavesBin = compound.getList("leaves", 10);
            for (int i = 0; i < leavesBin.size(); ++i) {
                tree.leaves.add(BlockPosUtil.readFromListNBT(leavesBin, i));
            }
        }
        return tree;
    }

    private void checkTree(@NotNull Level world, @NotNull BlockPos topLog) {
        if (!BlockUtils.isAnySolid((BlockState)world.getBlockState(new BlockPos(this.location.getX(), this.location.getY() - 1, this.location.getZ())))) {
            return;
        }
        int leafCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos leaf = new BlockPos(topLog.getX() + x, topLog.getY() + y, topLog.getZ() + z);
                    BlockState leaves = world.getBlockState(leaf);
                    if (!leaves.is(BlockTags.LEAVES) && !leaves.is(ModTags.hugeMushroomBlocks) || leaves.getOptionalValue((Property)LeavesBlock.PERSISTENT).orElse(false).booleanValue() || ++leafCount < 3) continue;
                    this.isTree = true;
                    return;
                }
            }
        }
    }

    public void findLogs(@NotNull Level world, @Nullable IColony colony) {
        this.addAndSearch(world, this.location, colony);
        this.woodBlocks.sort((c1, c2) -> (int)(c1.distSqr((Vec3i)this.location) - c2.distSqr((Vec3i)this.location)));
        if (this.getStumpLocations().isEmpty()) {
            this.fillTreeStumps(this.location.getY());
        }
    }

    public void fillTreeStumps(int yLevel) {
        for (BlockPos blockPos : this.woodBlocks) {
            if (blockPos.getY() != yLevel) continue;
            this.stumpLocations.add(blockPos);
        }
        if (this.stumpLocations.size() > 1 && this.sapling.is(Items.MANGROVE_PROPAGULE)) {
            BlockPos.MutableBlockPos acc = BlockPos.ZERO.mutable();
            for (BlockPos stump : this.stumpLocations) {
                acc = acc.move((Vec3i)stump);
            }
            BlockPos blockPos = new BlockPos(acc.getX() / this.stumpLocations.size(), acc.getY() / this.stumpLocations.size(), acc.getZ() / this.stumpLocations.size());
            this.stumpLocations.clear();
            this.stumpLocations.add(blockPos);
        }
    }

    private void addAndSearch(@NotNull Level world, @NotNull BlockPos log, @Nullable IColony colony) {
        if (this.woodBlocks.size() >= (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxTreeSize.get()) {
            return;
        }
        if (this.woodBlocks.contains(log)) {
            return;
        }
        if (!this.isBlockPartOfSameTree(world.getBlockState(log), world.getBlockState(this.location))) {
            return;
        }
        if (log.getY() < this.location.getY()) {
            this.location = log;
        }
        if (log.getY() > this.topLog.getY()) {
            this.topLog = log;
        }
        if (colony != null) {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!building.isInBuilding(log)) continue;
                return;
            }
        }
        this.woodBlocks.add(log);
        if (Compatibility.isDynamicBlock(BlockPosUtil.getBlock(world, log))) {
            return;
        }
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.offset(x, y, z);
                    BlockState block = BlockPosUtil.getBlockState(world, temp);
                    if (!block.is(ModTags.tree) && !Compatibility.isSlimeBlock(block.getBlock())) continue;
                    this.addAndSearch(world, temp, colony);
                }
            }
        }
    }

    private String logPrefix(BlockState block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()).getPath();
        return path.replaceFirst("(_log|_wood|_stem|_hyphae)$", "");
    }

    private boolean isBlockPartOfSameTree(@NotNull BlockState checkBlock, @NotNull BlockState stumpBlock) {
        if (checkBlock.is(ModTags.mangroveTree)) {
            return stumpBlock.is(ModTags.mangroveTree);
        }
        return checkBlock.getBlock() == stumpBlock.getBlock() || checkBlock.is(ModTags.extraTree) || this.logPrefix(checkBlock).equals(this.logPrefix(stumpBlock));
    }

    private void addAndSearch(@NotNull Level world) {
        int temp;
        int locXMin = this.location.getX() - 4;
        int locXMax = this.location.getX() + 4;
        int locYMin = this.location.getY() + 1;
        int locZMin = this.location.getZ() - 4;
        int locZMax = this.location.getZ() + 4;
        if (locXMin > locXMax) {
            temp = locXMax;
            locXMax = locXMin;
            locXMin = temp;
        }
        if (locZMin > locZMax) {
            temp = locZMax;
            locZMax = locZMin;
            locZMin = temp;
        }
        for (int locX = locXMin; locX <= locXMax; ++locX) {
            for (int locY = locYMin; locY < world.getHeight(); ++locY) {
                for (int locZ = locZMin; locZ <= locZMax; ++locZ) {
                    BlockPos leaf = new BlockPos(locX, locY, locZ);
                    BlockState block = world.getBlockState(leaf);
                    if (!block.is(BlockTags.LEAVES) && !block.is(ModTags.hugeMushroomBlocks) && !block.is(BlockTags.WART_BLOCKS) && !block.is(Blocks.SHROOMLIGHT) || block.getOptionalValue((Property)LeavesBlock.PERSISTENT).orElse(false).booleanValue()) continue;
                    this.leaves.add(leaf);
                }
            }
        }
    }

    public BlockPos pollNextLog() {
        return this.woodBlocks.pollLast();
    }

    public ItemStack getSapling() {
        return this.sapling;
    }

    public BlockPos pollNextLeaf() {
        return this.leaves.pollLast();
    }

    public BlockPos peekNextLog() {
        return this.woodBlocks.peekLast();
    }

    public BlockPos peekNextLeaf() {
        return this.leaves.peekLast();
    }

    public boolean hasLeaves() {
        return !this.leaves.isEmpty();
    }

    public boolean hasLogs() {
        return !this.woodBlocks.isEmpty();
    }

    public boolean isSlimeTree() {
        return this.slimeTree;
    }

    public boolean isDynamicTree() {
        return this.dynamicTree;
    }

    public boolean isNetherTree() {
        return this.netherTree;
    }

    @NotNull
    public List<BlockPos> getStumpLocations() {
        return new ArrayList<BlockPos>(this.stumpLocations);
    }

    public void removeStump(BlockPos pos) {
        this.stumpLocations.remove(pos);
    }

    public Property<?> getVariant() {
        return this.variant;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(@Nullable Object tree) {
        return tree != null && tree.getClass() == this.getClass() && ((Tree)tree).getLocation().equals((Object)this.location);
    }

    public void write(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (!this.isTree) {
            return;
        }
        BlockPosUtil.write(compound, "location", this.location);
        @NotNull ListTag logs = new ListTag();
        for (BlockPos blockPos : this.woodBlocks) {
            BlockPosUtil.writeToListNBT(logs, blockPos);
        }
        compound.put("Logs", (Tag)logs);
        @NotNull ListTag stumps = new ListTag();
        for (BlockPos stump : this.stumpLocations) {
            BlockPosUtil.writeToListNBT(stumps, stump);
        }
        compound.put("Stumps", (Tag)stumps);
        BlockPosUtil.write(compound, "topLog", this.topLog);
        compound.putBoolean("slimeTree", this.slimeTree);
        compound.putBoolean("dynamicTree", this.dynamicTree);
        compound.put("treesapling", this.sapling.saveOptional(provider));
        compound.putBoolean("netherTree", this.netherTree);
        @NotNull ListTag listTag = new ListTag();
        for (BlockPos pos : this.leaves) {
            BlockPosUtil.writeToListNBT(listTag, pos);
        }
        compound.put("leaves", (Tag)listTag);
    }

    public boolean isTree() {
        return this.isTree;
    }

    public static boolean checkIfInColony(BlockPos pos, IColony colony, LevelReader world, boolean allowInsideBuilding) {
        if (!colony.getLoadedChunks().contains(ChunkPos.asLong((BlockPos)pos))) {
            return false;
        }
        if (allowInsideBuilding || Compatibility.isDynamicBlock(world.getBlockState(pos).getBlock())) {
            return true;
        }
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!building.isInBuilding(pos)) continue;
            return false;
        }
        return true;
    }
}

