/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.aitasks;

import com.minecolonies.api.blocks.decorative.AbstractBlockGate;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EntityAIBreakDoor
extends BreakDoorGoal {
    private BlockPos prevDoorPos = BlockPos.ZERO;
    private int hardness = 0;
    private int breakChance = 1;

    public EntityAIBreakDoor(Mob entityIn) {
        super(entityIn, difficulty -> difficulty.getId() > 0);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && !this.mob.level().isEmptyBlock(this.doorPos);
    }

    public void start() {
        super.start();
        if (!this.prevDoorPos.equals((Object)this.doorPos)) {
            this.breakTime = 0;
        }
        this.prevDoorPos = this.doorPos;
        this.hardness = (int)(1.0f + this.mob.level().getBlockState(this.doorPos).getDestroySpeed((BlockGetter)this.mob.level(), this.doorPos));
        if (this.mob instanceof AbstractEntityMinecoloniesRaider) {
            ((AbstractEntityMinecoloniesRaider)this.mob).setCanBeStuck(false);
        }
    }

    public void stop() {
        super.stop();
        this.mob.level().destroyBlockProgress(this.mob.getId(), this.doorPos, -1);
        if (this.mob instanceof AbstractEntityMinecoloniesRaider) {
            ((AbstractEntityMinecoloniesRaider)this.mob).setCanBeStuck(true);
        }
    }

    public void tick() {
        BlockState toBreak;
        if (this.mob.getCommandSenderWorld().getDifficulty().getId() < 2 || !((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).raidersbreakdoors.get()).booleanValue()) {
            this.breakTime = 0;
            return;
        }
        if (this.mob.getRandom().nextInt(this.breakChance) != 0) {
            --this.breakTime;
        } else {
            Mob mob;
            double fasterBreakPerXNearby = 5.0;
            if (this.mob instanceof AbstractEntityMinecoloniesRaider && !this.mob.level().isClientSide() && this.mob.level().getBlockState(this.doorPos).getBlock() instanceof AbstractBlockGate) {
                IColony colony = ((AbstractEntityMinecoloniesRaider)this.mob).getColony();
                fasterBreakPerXNearby += colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MECHANIC_ENHANCED_GATES);
            }
            this.breakChance = (int)Math.max(1.0, (double)this.hardness / (1.0 + (double)this.mob.level().getEntitiesOfClass(AbstractEntityMinecoloniesRaider.class, this.mob.getBoundingBox().inflate(5.0)).size() / (fasterBreakPerXNearby /= 2.0)));
            if (this.mob.getRandom().nextInt(this.breakChance) == 0 && (mob = this.mob) instanceof AbstractEntityMinecoloniesRaider) {
                AbstractEntityMinecoloniesRaider raider = (AbstractEntityMinecoloniesRaider)mob;
                if (this.mob.level().getBlockState(this.doorPos).getBlock() instanceof AbstractBlockGate) {
                    ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
                    for (ICitizenData entry : raider.getColony().getCitizenManager().getCitizens()) {
                        if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || BlockPosUtil.getDistanceSquared(entry.getEntity().get().blockPosition(), this.doorPos) >= 10000L || entry.getJob().getWorkerAI() == null || !((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp(this.doorPos) || this.doorPos.equals((Object)((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).getCurrentPatrolPoint())) continue;
                        possibleGuards.add(entry.getEntity().get());
                    }
                    possibleGuards.sort(Comparator.comparingInt(guard -> (int)this.doorPos.distSqr((Vec3i)guard.blockPosition())));
                    BlockPos gotoPos = BlockPos.containing((Position)Vec3.atCenterOf((Vec3i)this.doorPos).add(Vec3.atCenterOf((Vec3i)raider.getColony().getCenter()).subtract(Vec3.atCenterOf((Vec3i)this.doorPos)).normalize().multiply(3.0, 0.0, 3.0)));
                    for (int i = 0; i < possibleGuards.size() && i <= 3; ++i) {
                        ((AbstractEntityAIGuard)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI()).setNextPatrolTargetAndMove(gotoPos);
                    }
                }
            }
        }
        if (this.breakTime == this.getDoorBreakTime() - 1 && (toBreak = this.mob.level().getBlockState(this.doorPos)).getBlock() instanceof AbstractBlockGate) {
            ((AbstractBlockGate)toBreak.getBlock()).removeGate(this.mob.level(), this.doorPos, ((Direction)toBreak.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise());
        }
        super.tick();
    }
}

