/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding;

import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MNode
implements Comparable<MNode> {
    private static final int HASH_A = 12;
    private static final int HASH_B = 20;
    private static final int HASH_C = 24;
    @NotNull
    public final int x;
    public final int y;
    public final int z;
    @Nullable
    public MNode parent;
    private int counterAdded;
    private double cost;
    private double heuristic;
    private int visitedCount = 0;
    private boolean ladder = false;
    private boolean swimming = false;
    private boolean isOnRails = false;
    private boolean isCornerNode = false;
    private boolean isReachedByWorker = false;

    public MNode(@Nullable MNode parent, @NotNull int posX, int posY, int posZ, double cost, double heuristic) {
        this.parent = parent;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.cost = cost;
        this.heuristic = heuristic;
    }

    public MNode(RegistryFriendlyByteBuf byteBuf) {
        if (byteBuf.readBoolean()) {
            this.parent = new MNode(null, byteBuf.readVarInt(), byteBuf.readVarInt(), byteBuf.readVarInt(), 0.0, 0.0);
        }
        this.x = byteBuf.readVarInt();
        this.y = byteBuf.readVarInt();
        this.z = byteBuf.readVarInt();
        this.cost = byteBuf.readDouble();
        this.heuristic = byteBuf.readDouble();
        this.isReachedByWorker = byteBuf.readBoolean();
    }

    public void serializeToBuf(RegistryFriendlyByteBuf byteBuf) {
        byteBuf.writeBoolean(this.parent != null);
        if (this.parent != null) {
            byteBuf.writeVarInt(this.parent.x);
            byteBuf.writeVarInt(this.parent.y);
            byteBuf.writeVarInt(this.parent.z);
        }
        byteBuf.writeVarInt(this.x);
        byteBuf.writeVarInt(this.y);
        byteBuf.writeVarInt(this.z);
        byteBuf.writeDouble(this.cost);
        byteBuf.writeDouble(this.heuristic);
        byteBuf.writeBoolean(this.isReachedByWorker);
    }

    @Override
    public int compareTo(@NotNull MNode o) {
        if (this.cost + this.heuristic < o.cost + o.heuristic) {
            return -1;
        }
        if (this.cost + this.heuristic > o.cost + o.heuristic) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public int hashCode() {
        return this.x ^ (this.z << 12 | this.z >> 20) ^ this.y << 24;
    }

    public boolean equals(@Nullable Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            @Nullable MNode other = (MNode)o;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public boolean isVisited() {
        return this.visitedCount != 0;
    }

    public int getVisitedCount() {
        return this.visitedCount;
    }

    public boolean isLadder() {
        return this.ladder;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void increaseVisited() {
        ++this.visitedCount;
    }

    public double getScore() {
        return this.cost + this.heuristic;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setLadder() {
        this.ladder = true;
    }

    public void setSwimming() {
        this.swimming = true;
    }

    public double getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(double heuristic) {
        this.heuristic = heuristic;
    }

    public int getDebugAddedIndex() {
        return this.counterAdded;
    }

    public void setCounterAdded(int counterAdded) {
        this.counterAdded = counterAdded;
    }

    public void setOnRails(boolean isOnRails) {
        this.isOnRails = isOnRails;
    }

    public boolean isOnRails() {
        return this.isOnRails;
    }

    public void setReachedByWorker(boolean reached) {
        this.isReachedByWorker = reached;
    }

    public boolean isReachedByWorker() {
        return this.isReachedByWorker;
    }

    public void setCornerNode(boolean isCornerNode) {
        this.isCornerNode = isCornerNode;
    }

    public boolean isCornerNode() {
        return this.isCornerNode;
    }

    public int getCounterAdded() {
        return this.counterAdded;
    }

    public static int computeNodeKey(int x, int y, int z) {
        return (x & 0xFFF) << 20 | (y & 0xFF) << 12 | z & 0xFFF;
    }

    public String toString() {
        return "Node: [" + this.x + "," + this.y + "," + this.z + "] visited:" + this.visitedCount + " cost:" + this.cost + " heuristic:" + this.heuristic;
    }
}

