/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.quests.registries.QuestRegistries;
import com.minecolonies.api.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class QuestTranslationProvider
implements DataProvider {
    private final PackOutput packOutput;

    public QuestTranslationProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @NotNull
    public String getName() {
        return "QuestTranslationProvider";
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        PackOutput.PathProvider questProvider = this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "colony/quests");
        ArrayList quests = new ArrayList();
        try (PathPackResources pack = new PathPackResources(new PackLocationInfo("mod/minecolonies/src", (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty()), Path.of("..", "..", "src", "main", "resources"));){
            pack.listResources(PackType.SERVER_DATA, "minecolonies", "colony/quests", (questId, stream) -> {
                if (!questId.getPath().endsWith(".json")) {
                    return;
                }
                ResourceLocation questPath = new ResourceLocation(questId.getNamespace(), questId.getPath().replace("colony/quests/", "").replace(".json", ""));
                String baseKey = questPath.getNamespace() + ".quests." + questPath.getPath().replace("/", ".");
                JsonObject langJson = new JsonObject();
                quests.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        JsonObject questJson;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)stream.get());){
                            questJson = GsonHelper.parse((Reader)reader);
                        }
                        this.processQuest(langJson, baseKey, questJson);
                        return questJson;
                    }
                    catch (Exception e) {
                        Log.getLogger().error("Failed to process {}", (Object)questPath.toString(), (Object)e);
                        return null;
                    }
                }, Util.backgroundExecutor()).thenComposeAsync(json -> {
                    if (json != null) {
                        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)questProvider.json(questPath)).thenApply(q -> langJson);
                    }
                    return CompletableFuture.completedFuture(null);
                }, (Executor)Util.backgroundExecutor()));
            });
        }
        return CompletableFuture.allOf((CompletableFuture[])quests.toArray(CompletableFuture[]::new)).thenComposeAsync(v -> this.saveLanguage(cache, quests.stream().map(q -> (JsonObject)q.join()).toList()), (Executor)Util.backgroundExecutor());
    }

    @NotNull
    private CompletableFuture<?> saveLanguage(@NotNull CachedOutput cache, @NotNull List<JsonObject> langJsons) {
        JsonObject langJson = new JsonObject();
        for (JsonObject questLang : langJsons) {
            for (Map.Entry entry : questLang.entrySet()) {
                langJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        PackOutput.PathProvider langProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
        Path langFile = langProvider.file(new ResourceLocation("minecolonies", "quests"), "json");
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)langJson, (Path)langFile);
    }

    private void processQuest(JsonObject langJson, String baseKey, JsonObject json) {
        String name = json.get("name").getAsString();
        langJson.addProperty(baseKey, name);
        json.addProperty("name", baseKey);
        int objectiveCount = 0;
        for (JsonElement objectivesJson : json.get("objectives").getAsJsonArray()) {
            String objectiveKey = baseKey + ".obj" + objectiveCount;
            JsonObject objective = objectivesJson.getAsJsonObject();
            this.processObjective(langJson, objectiveKey, objective);
            ++objectiveCount;
        }
    }

    private void processObjective(JsonObject langJson, String baseKey, JsonObject json) {
        ResourceLocation type = ResourceLocation.parse((String)json.get("type").getAsString());
        if (type.equals((Object)QuestRegistries.DIALOGUE_OBJECTIVE_ID)) {
            langJson.addProperty(baseKey, json.get("text").getAsString());
            json.addProperty("text", baseKey);
            int answerCount = 0;
            for (JsonElement answerJson : json.get("options").getAsJsonArray()) {
                String answerKey = baseKey + ".answer" + answerCount;
                langJson.addProperty(answerKey, answerJson.getAsJsonObject().get("answer").getAsString());
                answerJson.getAsJsonObject().addProperty("answer", answerKey);
                JsonObject result = answerJson.getAsJsonObject().get("result").getAsJsonObject();
                this.processObjective(langJson, answerKey + ".reply", result);
                ++answerCount;
            }
        }
    }
}

