/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingResourcesModule;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.interactionhandling.SimpleNotificationInteraction;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.server.PlayerAssistantBuildRequestMessage;
import com.minecolonies.core.placementhandlers.SolidPlaceholderPlacementHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemAssistantHammer
extends AbstractItemMinecolonies {
    private int reach = 1;

    public ItemAssistantHammer(String id, Item.Properties properties, int reach) {
        super(id, properties);
        this.reach = reach;
    }

    public void useOnBlock(Player player, BlockPos interactPos) {
        Level level = player.level();
        IColonyView view = IColonyManager.getInstance().getColonyView(level, interactPos);
        if (view == null || level == null || !view.getPermissions().hasPermission(player, Action.PLACE_BLOCKS)) {
            return;
        }
        boolean unclaimed = true;
        for (IWorkOrder iWorkOrder : view.getWorkOrders()) {
            if (!iWorkOrder.isClaimed() || view.getBuilding(iWorkOrder.getClaimedBy()) == null || view.getBuilding(iWorkOrder.getClaimedBy()).getBuildingType() != ModBuildings.builder.get() || iWorkOrder.getBoundingBox() == null || !iWorkOrder.getBoundingBox().inflate(2.0).contains(Vec3.atLowerCornerOf((Vec3i)interactPos))) continue;
            unclaimed = false;
            if (iWorkOrder.getBlueprint() == null) {
                iWorkOrder.loadBlueprint(player.level(), b -> {});
                return;
            }
            ArrayList<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>(PlacementHandlers.handlers);
            SolidPlaceholderPlacementHandler solidPlaceHolderHandler = new SolidPlaceholderPlacementHandler();
            solidPlaceHolderHandler.setReplacement(view.getBuilding(iWorkOrder.getClaimedBy()).getModuleView(BuildingModules.BUILDER_SETTINGS).getSetting(BuildingMiner.FILL_BLOCK).getValue().getBlock().defaultBlockState());
            handlers.add(0, solidPlaceHolderHandler);
            BuildAttemptResult buildAttemptResult = this.tryBuildingBlockNearby(player, view, iWorkOrder, interactPos, handlers);
            if (!buildAttemptResult.areBlocksToBuildNearby() || buildAttemptResult.didTryBuilding()) break;
            player.displayClientMessage((Component)Component.translatable((String)"item.minecolonies.assistanthammer.noitems"), true);
            break;
        }
        if (unclaimed) {
            player.displayClientMessage((Component)Component.translatable((String)"item.minecolonies.assistanthammer.onlyactive"), true);
        }
    }

    public void placeBlock(Player player, IColony colony, IWorkOrder workOrder, BlockPos interactPos) {
        if (workOrder.isClaimed()) {
            BuildingProgressStage stage = workOrder.getStage();
            if (stage == BuildingProgressStage.CLEAR || stage == BuildingProgressStage.CLEAR_NON_SOLIDS) {
                player.displayClientMessage((Component)Component.translatable((String)"item.minecolonies.assistanthammer.notcleared"), true);
                player.inventoryMenu.broadcastFullState();
                return;
            }
            if (workOrder.getBlueprint() == null) {
                workOrder.loadBlueprint(player.level(), b -> {});
                player.displayClientMessage((Component)Component.translatable((String)"item.minecolonies.assistanthammer.notloaded"), true);
                player.inventoryMenu.broadcastFullState();
                return;
            }
            ArrayList<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>(PlacementHandlers.handlers);
            SolidPlaceholderPlacementHandler solidPlaceHolderHandler = new SolidPlaceholderPlacementHandler();
            solidPlaceHolderHandler.setReplacement(((SettingsModule)colony.getBuildingManager().getBuilding(workOrder.getClaimedBy()).getModule(BuildingModules.BUILDER_SETTINGS)).getSetting(BuildingMiner.FILL_BLOCK).getValue().getBlock().defaultBlockState());
            handlers.add(0, solidPlaceHolderHandler);
            BuildAttemptResult buildAttemptResult = this.tryBuildingBlockNearby(player, colony, workOrder, interactPos, handlers);
            if (buildAttemptResult.areBlocksToBuildNearby() && !buildAttemptResult.didTryBuilding()) {
                player.displayClientMessage((Component)Component.translatable((String)"item.minecolonies.assistanthammer.noitems"), true);
                player.inventoryMenu.broadcastFullState();
            }
            if (buildAttemptResult.areBlocksToBuildNearby() && buildAttemptResult.didTryBuilding() && !player.isCreative()) {
                player.getMainHandItem().hurtAndBreak(player.getMainHandItem().getItem().damageItem(player.getMainHandItem(), 1, (LivingEntity)player, s -> {}), (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            BlockPos interactPos = context.getClickedPos().relative(context.getClickedFace());
            this.useOnBlock(context.getPlayer(), interactPos);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            BlockPos interactPos = BlockPos.containing((Position)player.getEyePosition().add(player.getLookAngle().multiply(3.0, 3.0, 3.0)));
            this.useOnBlock(player, interactPos);
        }
        return InteractionResultHolder.success((Object)player.getMainHandItem());
    }

    @NotNull
    private BuildAttemptResult tryBuildingBlockNearby(Player player, IColony colony, IWorkOrder workOrder, BlockPos interactPos, List<IPlacementHandler> handlers) {
        BlockPos.MutableBlockPos workPos = new BlockPos.MutableBlockPos();
        boolean areBlocksToBuildNearby = false;
        player.getCooldowns().addCooldown((Item)this, 5);
        for (int currentDistance = 0; currentDistance <= this.reach; ++currentDistance) {
            for (int x = -currentDistance; x <= currentDistance; ++x) {
                for (int y = -currentDistance; y <= currentDistance; ++y) {
                    for (int z = -currentDistance; z <= currentDistance; ++z) {
                        IBuilding building;
                        IPlacementHandler.ActionProcessingResult actionProcessingResult;
                        int distanceSq = x * x + y * y + z * z;
                        if (distanceSq > currentDistance * currentDistance) continue;
                        workPos.set(x + interactPos.getX(), y + interactPos.getY(), z + interactPos.getZ());
                        BlockState levelState = player.level().getBlockState((BlockPos)workPos);
                        BlockInfo blockInfo = (BlockInfo)workOrder.getBlueprint().getBlockInfoAsMap().get(workPos.subtract((Vec3i)workOrder.getLocation()).offset((Vec3i)workOrder.getBlueprint().getPrimaryBlockOffset()));
                        if (blockInfo == null || blockInfo.getState() == null || blockInfo.getState().getBlock() == levelState.getBlock() || !levelState.isAir() && levelState.getFluidState().isEmpty() || blockInfo.getState().getBlock() == ModBlocks.blockSubstitution.get() || blockInfo.getState().getBlock() == ModBlocks.blockFluidSubstitution.get() || blockInfo.getState().getBlock() == ModBlocks.blockTagSubstitution.get()) continue;
                        ArrayList<ItemStack> requiredItem = new ArrayList<ItemStack>();
                        IPlacementHandler foundHandler = null;
                        for (IPlacementHandler iPlacementHandler : handlers) {
                            if (!iPlacementHandler.canHandle(player.level(), BlockPos.ZERO, blockInfo.getState())) continue;
                            List itemList = iPlacementHandler.getRequiredItems(player.level(), (BlockPos)workPos, blockInfo.getState(), blockInfo.getTileEntityData(), false);
                            requiredItem.addAll(itemList);
                            foundHandler = iPlacementHandler;
                            break;
                        }
                        if (foundHandler == null) {
                            requiredItem.add(BlockUtils.getItemStackFromBlockState((BlockState)blockInfo.getState()));
                        }
                        if (requiredItem.size() != 1) continue;
                        areBlocksToBuildNearby = true;
                        boolean hasItems = true;
                        if (!player.isCreative()) {
                            for (ItemStack required : requiredItem) {
                                boolean found = false;
                                for (ItemStack stack : player.getInventory().items) {
                                    if (!ItemStackUtils.compareItemStacksIgnoreStackSize(required, stack).booleanValue()) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                hasItems = false;
                            }
                        }
                        if (!hasItems || (actionProcessingResult = foundHandler.handle(colony.getWorld(), (BlockPos)workPos, blockInfo.getState(), blockInfo.getTileEntityData(), false, workOrder.getLocation(), workOrder.getRotationMirror())) == IPlacementHandler.ActionProcessingResult.DENY) continue;
                        if (!colony.getWorld().isClientSide() && (building = colony.getBuildingManager().getBuilding(workOrder.getLocation())) != null) {
                            building.registerBlockPosition(blockInfo.getState(), (BlockPos)workPos, colony.getWorld());
                        }
                        if (!player.isCreative()) {
                            InventoryUtils.removeStacksFromItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), requiredItem);
                        }
                        if (colony.getWorld().isClientSide) {
                            new PlayerAssistantBuildRequestMessage(colony, workOrder.getID(), interactPos).sendToServer();
                        } else {
                            IBuilding buildingBuilder;
                            building = colony.getBuildingManager().getBuilding(workOrder.getClaimedBy());
                            for (ItemStack stack : requiredItem) {
                                ((BuildingResourcesModule)building.getModule(BuildingModules.BUILDING_RESOURCES)).reduceNeededResource(stack, 1);
                            }
                            if (ColonyConstants.rand.nextInt(20) == 0 && (buildingBuilder = colony.getBuildingManager().getBuilding(workOrder.getClaimedBy())) != null) {
                                ((WorkerBuildingModule)buildingBuilder.getModule(BuildingModules.BUILDER_WORK)).getAssignedCitizen().forEach(citizen -> citizen.triggerInteraction(new SimpleNotificationInteraction((Component)Component.translatable((String)"item.minecolonies.assistanthammer.happybuilder"), ChatPriority.CHITCHAT)));
                            }
                        }
                        for (int i = 0; i < 50; ++i) {
                            player.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockInfo.getState()), (double)((float)workPos.getX() + 0.5f) - 0.5 + (double)ColonyConstants.rand.nextFloat(1.5f), (double)((float)workPos.getY() + 0.5f) - 0.5 + (double)ColonyConstants.rand.nextFloat(1.5f), (double)((float)workPos.getZ() + 0.5f) - 0.5 + (double)ColonyConstants.rand.nextFloat(1.5f), ColonyConstants.rand.nextGaussian() * 5.0, ColonyConstants.rand.nextGaussian() * 5.0, ColonyConstants.rand.nextGaussian() * 5.0);
                        }
                        if (player.level().isClientSide() && ColonyConstants.rand.nextInt(5) == 0) {
                            player.level().playSound(player, (BlockPos)workPos, SoundEvents.CHAIN_HIT, SoundSource.BLOCKS, (0.75f + ColonyConstants.rand.nextFloat(0.5f)) * 2.0f, 0.9f + ColonyConstants.rand.nextFloat(0.2f));
                        }
                        player.level().playSound(player, (BlockPos)workPos, blockInfo.getState().getSoundType().getPlaceSound(), SoundSource.BLOCKS, blockInfo.getState().getSoundType().getVolume() * (0.75f + ColonyConstants.rand.nextFloat(0.5f)) * 2.0f, blockInfo.getState().getSoundType().getPitch() * (0.9f + ColonyConstants.rand.nextFloat(0.2f)));
                        return new BuildAttemptResult(true, true);
                    }
                }
            }
        }
        return new BuildAttemptResult(areBlocksToBuildNearby, false);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltipList, @NotNull TooltipFlag flagIn) {
        tooltipList.add((Component)Component.translatable((String)"item.minecolonies.assistanthammer.reach", (Object[])new Object[]{this.reach}).withStyle(ChatFormatting.BLUE));
        tooltipList.add((Component)Component.translatable((String)"item.minecolonies.assistanthammer.desc").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
    }

    private record BuildAttemptResult(boolean areBlocksToBuildNearby, boolean didTryBuilding) {
    }
}

