/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.core.colony.ColonyView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class OpenBuildingUIMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"open_building_ui", OpenBuildingUIMessage::new);
    private int colonyId;
    private BlockPos buildingId;
    private ResourceKey<Level> dimension;

    public OpenBuildingUIMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.colonyId = buf.readInt();
        this.buildingId = buf.readBlockPos();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
    }

    public OpenBuildingUIMessage(@NotNull IBuilding building) {
        super(TYPE);
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.dimension = building.getColony().getDimension();
    }

    public void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBlockPos(this.buildingId);
        buf.writeUtf(this.dimension.location().toString());
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        ColonyView colonyView;
        Object object = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (object instanceof ColonyView && (object = (colonyView = (ColonyView)object).getBuilding(this.buildingId)) instanceof AbstractBuildingView) {
            AbstractBuildingView buildingView = (AbstractBuildingView)object;
            buildingView.openGui(false);
        }
    }
}

