/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.util.Utils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class SwitchBuildingWithToolMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"switch_building_with_tool", SwitchBuildingWithToolMessage::new);
    private final ItemStack stack;

    public SwitchBuildingWithToolMessage(ItemStack stack) {
        super(TYPE);
        this.stack = stack;
    }

    protected SwitchBuildingWithToolMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.stack = Utils.deserializeCodecMess(buf);
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        Utils.serializeCodecMess(buf, this.stack);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        int i;
        int stackSlot = -1;
        int buildToolSlot = -1;
        for (i = 0; i < 9; ++i) {
            if (ItemStack.isSameItem((ItemStack)player.getInventory().getItem(i), (ItemStack)this.stack)) {
                stackSlot = i;
                continue;
            }
            if (player.getInventory().getItem(i).getItem() != ModItems.buildTool.get()) continue;
            buildToolSlot = i;
        }
        for (i = 9; i < player.getInventory().getContainerSize(); ++i) {
            if (player.getInventory().getItem(i).getItem() != ModItems.buildTool.get()) continue;
            buildToolSlot = i;
        }
        if (stackSlot != -1 && buildToolSlot != -1) {
            player.getInventory().setItem(buildToolSlot, player.getInventory().getItem(stackSlot).copy());
            player.getInventory().setItem(stackSlot, new ItemStack((ItemLike)ModItems.buildTool.get(), 1));
        }
    }
}

