/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.eventbus.events.colony.ColonyNameChangedModEvent;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class TownHallRenameMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"town_hall_rename", TownHallRenameMessage::new);
    private static final int MAX_NAME_LENGTH = 25;
    private static final int SUBSTRING_LENGTH = 24;
    private final String name;

    public TownHallRenameMessage(@NotNull IColonyView colony, String name) {
        super(TYPE, colony);
        this.name = name.length() <= 25 ? name : name.substring(0, 24);
    }

    protected TownHallRenameMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        String nameLong = buf.readUtf(Short.MAX_VALUE);
        this.name = nameLong.length() <= 25 ? nameLong : nameLong.substring(0, 24);
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeUtf(this.name);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        colony.setName(this.name);
        IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyNameChangedModEvent(colony));
    }
}

