/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class RecallCitizenHutMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"recall_citizen_hut", RecallCitizenHutMessage::new);

    public RecallCitizenHutMessage(@NotNull AbstractBuildingView building) {
        super(TYPE, building);
    }

    protected RecallCitizenHutMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        BlockPos location = building.getPosition();
        Level world = colony.getWorld();
        for (ICitizenData citizenData : building.getAllAssignedCitizen()) {
            Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
            if (!optionalEntityCitizen.isPresent()) {
                Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                citizenData.setNextRespawnPosition(EntityUtils.getSpawnPoint(world, location));
                citizenData.updateEntityIfNecessary();
                optionalEntityCitizen = citizenData.getEntity();
            }
            if (!optionalEntityCitizen.isPresent() || TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), world, location)) continue;
            MessageUtils.format("com.minecolonies.coremod.workerhuts.recallfail", new Object[0]).sendTo(new Player[]{player});
        }
    }
}

