/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ChangeRecipePriorityMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"change_recipe_priority", ChangeRecipePriorityMessage::new);
    private final int recipeLocation;
    private final boolean up;
    private final int id;
    private final boolean fullMove;

    public ChangeRecipePriorityMessage(@NotNull IBuildingView building, int location, boolean up, int id, boolean fullMove) {
        super(TYPE, building);
        this.recipeLocation = location;
        this.up = up;
        this.id = id;
        this.fullMove = fullMove;
    }

    protected ChangeRecipePriorityMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.recipeLocation = buf.readInt();
        this.up = buf.readBoolean();
        this.id = buf.readInt();
        this.fullMove = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.recipeLocation);
        buf.writeBoolean(this.up);
        buf.writeInt(this.id);
        buf.writeBoolean(this.fullMove);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof AbstractCraftingBuildingModule) {
            AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)iBuildingModule;
            if (this.up) {
                module.switchOrder(this.recipeLocation, this.recipeLocation - 1, this.fullMove);
            } else {
                module.switchOrder(this.recipeLocation, this.recipeLocation + 1, this.fullMove);
            }
        }
    }
}

