/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.structures;

import com.minecolonies.api.util.Log;
import com.minecolonies.core.structures.MineColoniesStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class EmptyColonyStructure
extends Structure {
    public static final MapCodec<EmptyColonyStructure> COLONY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EmptyColonyStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)10).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.optionalFieldOf("allow_cave", (Object)false).forGetter(structure -> structure.allowCave), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(p_307187_ -> p_307187_.poolAliases)).apply((Applicative)instance, EmptyColonyStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<PoolAliasBinding> poolAliases;
    private boolean allowCave;

    public EmptyColonyStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, boolean allowCave, List<PoolAliasBinding> poolAliases) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.allowCave = allowCave;
        this.poolAliases = poolAliases;
    }

    public StructureType<?> type() {
        return (StructureType)MineColoniesStructures.EMPTY_COLONY.get();
    }

    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isFeatureChunk(Structure.GenerationContext context) {
        BlockPos blockPos = context.chunkPos().getWorldPosition();
        int landHeight = context.chunkGenerator().getFirstOccupiedHeight(blockPos.getX(), blockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        NoiseColumn columnOfBlocks = context.chunkGenerator().getBaseColumn(blockPos.getX(), blockPos.getZ(), context.heightAccessor(), context.randomState());
        BlockState topBlock = columnOfBlocks.getBlock(landHeight);
        return topBlock.getFluidState().isEmpty() && landHeight < 200;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (this.allowCave) {
            BlockPos.MutableBlockPos result = EmptyColonyStructure.isFeatureChunkCave(context);
            if (result != null) {
                Optional structurePiecesGenerator = JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)result, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.create(this.poolAliases, (BlockPos)result, (long)context.seed()), (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING);
                if (structurePiecesGenerator.isPresent()) {
                    Log.getLogger().debug("New Empty colony at" + String.valueOf(result));
                }
                return structurePiecesGenerator;
            }
            return Optional.empty();
        }
        if (!EmptyColonyStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.chunkPos().getMiddleBlockPosition(0);
        int topLandY = context.chunkGenerator().getFirstFreeHeight(blockpos.getX(), blockpos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        Optional structurePiecesGenerator = JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)(blockpos = blockpos.above(topLandY)), (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.create(this.poolAliases, (BlockPos)blockpos, (long)context.seed()), (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING);
        if (structurePiecesGenerator.isPresent()) {
            Log.getLogger().debug("New Empty colony at" + String.valueOf(blockpos));
        }
        return structurePiecesGenerator;
    }

    private static BlockPos.MutableBlockPos isFeatureChunkCave(Structure.GenerationContext context) {
        BlockPos blockPos = context.chunkPos().getWorldPosition();
        ChunkPos chunkPos = new ChunkPos(blockPos);
        int currentY = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 10; ++i) {
            currentY += context.random().nextInt(0, 30);
            for (int curChunkX = chunkPos.x - 1; curChunkX <= chunkPos.x + 1; ++curChunkX) {
                for (int curChunkZ = chunkPos.z - 1; curChunkZ <= chunkPos.z + 1; ++curChunkZ) {
                    BlockState state;
                    NoiseColumn blockView = context.chunkGenerator().getBaseColumn(mutable.getX(), mutable.getZ(), context.heightAccessor(), context.randomState());
                    mutable.set(curChunkX << 4, currentY, curChunkZ << 4);
                    if (!blockView.getBlock(mutable.getY()).isAir()) continue;
                    int airCount = 1;
                    while (mutable.getY() > context.chunkGenerator().getMinY() && (state = blockView.getBlock(mutable.getY())).isAir()) {
                        ++airCount;
                        mutable.move(Direction.DOWN);
                    }
                    mutable.setY(currentY);
                    while (mutable.getY() < context.chunkGenerator().getMinY() + context.chunkGenerator().getGenDepth() && (state = blockView.getBlock(mutable.getY())).isAir() && ++airCount < 32) {
                        mutable.move(Direction.UP);
                    }
                    if (airCount < 32) continue;
                    return mutable;
                }
            }
        }
        return null;
    }
}

