/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.tileentities.AbstractTileEntityBarrel;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBarrel
extends AbstractTileEntityBarrel
implements ITickable {
    private boolean done = false;
    private int items = 0;
    private int timer = 0;
    private static final int TIMER_END = 24000;
    private static final int AVERAGE_TICKS = 20;

    public TileEntityBarrel(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.BARREL.get(), pos, state);
    }

    @Override
    public void tick() {
        Level world = this.getLevel();
        if (!world.isClientSide && world.getGameTime() % (long)(world.random.nextInt(40) + 1) == 0L) {
            this.updateTick(world, this.getBlockPos(), world.getBlockState(this.getBlockPos()), new Random());
        }
    }

    public void updateTick(Level worldIn, BlockPos pos, BlockState state, Random rand) {
        if (this.getItems() == 64) {
            this.doBarrelCompostTick(worldIn, pos, state);
        }
        if (this.done) {
            ((ServerLevel)worldIn).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.5, (double)this.getBlockPos().getZ() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
    }

    private void doBarrelCompostTick(Level worldIn, BlockPos pos, BlockState blockState) {
        ++this.timer;
        if (this.timer >= 1200) {
            this.timer = 0;
            this.items = 0;
            this.done = true;
            this.updateBlock(worldIn);
        }
    }

    public boolean useBarrel(Player playerIn, ItemStack itemstack, @Nullable Direction hitFace) {
        if (this.done) {
            ItemStack compostStack = new ItemStack((ItemLike)ModItems.compost, 6);
            if (hitFace != null) {
                playerIn.level().addFreshEntity((Entity)new ItemEntity(playerIn.level(), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.75, (double)this.worldPosition.getZ() + 0.5, compostStack, (double)((float)hitFace.getStepX() / 5.0f), (double)((float)hitFace.getStepY() / 5.0f + 0.2f), (double)((float)hitFace.getStepZ() / 5.0f)));
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                if (!playerIn.getInventory().add(compostStack)) {
                    playerIn.level().addFreshEntity((Entity)new ItemEntity(playerIn.level(), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.75, (double)this.worldPosition.getZ() + 0.5, compostStack, 0.0, (double)0.2f, 0.0));
                }
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.done = false;
            return true;
        }
        RecipeHolder<CompostRecipe> recipe = TileEntityBarrel.findCompostRecipe(itemstack);
        if (recipe == null) {
            return false;
        }
        if (this.items == 64) {
            MessageUtils.format("entity.barrel.working", new Object[0]).sendTo(playerIn);
            return false;
        }
        this.consumeNeededItems(itemstack, recipe);
        return true;
    }

    private void consumeNeededItems(ItemStack itemStack, RecipeHolder<CompostRecipe> recipe) {
        int factor = ((CompostRecipe)recipe.value()).getStrength();
        int availableItems = itemStack.getCount() * factor;
        int neededItems = 64 - this.items;
        int itemsToRemove = Math.min(neededItems, availableItems);
        this.items += itemsToRemove;
        ItemStackUtils.changeSize(itemStack, -(itemsToRemove /= factor));
    }

    @Nullable
    private static RecipeHolder<CompostRecipe> findCompostRecipe(ItemStack itemStack) {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfCompostRecipes().get(itemStack.getItem());
    }

    public void updateBlock(Level worldIn) {
        BlockState barrel = this.level.getBlockState(this.worldPosition);
        if (barrel.getBlock() == ModBlocks.blockBarrel) {
            worldIn.setBlockAndUpdate(this.worldPosition, AbstractBlockBarrel.changeStateOverFullness(this, barrel));
            this.setChanged();
        }
    }

    public void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("items", this.items);
        compound.putInt("timer", this.timer);
        compound.putBoolean("done", this.done);
    }

    public void loadAdditional(CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.items = compound.getInt("items");
        this.timer = compound.getInt("timer");
        this.done = compound.getBoolean("done");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        CompoundTag compound = packet.getTag();
        this.loadAdditional(compound, provider);
        this.setChanged();
    }

    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
        }
    }

    public final void handleUpdateTag(CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.items = tag.getInt("items");
        this.timer = tag.getInt("timer");
        this.done = tag.getBoolean("done");
    }

    @Override
    public int getItems() {
        return this.items;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean checkIfWorking() {
        return this.items == 64;
    }

    @Override
    public boolean addItem(ItemStack item) {
        RecipeHolder<CompostRecipe> recipe = TileEntityBarrel.findCompostRecipe(item);
        if (recipe != null && this.items < 64) {
            this.consumeNeededItems(item, recipe);
            this.updateBlock(this.level);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack retrieveCompost(double multiplier) {
        if (this.done) {
            this.done = false;
            this.updateBlock(this.level);
            return new ItemStack((ItemLike)ModItems.compost, (int)(6.0 * multiplier));
        }
        return ItemStack.EMPTY;
    }
}

