/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.ColonyConnectionNode;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityColonySign
extends BlockEntity
implements ITickable {
    private int colonyId = -1;
    private int targetColonyId = -1;
    private BlockPos anchor = null;
    private String colonyNameCache = "";
    private String targetColonyNameCache = "";
    private float rotation;
    private int distance;
    private int targetColonyDistance;
    private final int tickOffset = MathUtils.RANDOM.nextInt(20);

    public TileEntityColonySign(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.COLONY_SIGN.get(), pos, state);
    }

    public void setChanged() {
        if (this.level != null) {
            WorldUtil.markChunkDirty(this.level, this.worldPosition);
        }
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.colonyId = compound.getInt("colony");
        this.colonyNameCache = compound.getString("name");
        if (compound.contains("pos")) {
            this.anchor = BlockPosUtil.read(compound, "pos");
        }
        this.rotation = compound.getFloat("rotation");
        this.targetColonyId = compound.getInt("targetcolony");
        this.targetColonyNameCache = compound.getString("targetname");
        this.distance = compound.getInt("distance");
        this.targetColonyDistance = compound.getInt("targetdistance");
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("colony", this.colonyId);
        compound.putString("name", this.colonyNameCache);
        if (this.anchor != null) {
            BlockPosUtil.write(compound, "pos", this.anchor);
        }
        compound.putFloat("rotation", this.rotation);
        compound.putInt("targetcolony", this.targetColonyId);
        compound.putString("targetname", this.targetColonyNameCache);
        compound.putInt("distance", this.distance);
        compound.putInt("targetdistance", this.targetColonyDistance);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithId(provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        CompoundTag compound = packet.getTag();
        this.loadAdditional(compound, provider);
    }

    @Override
    public void tick() {
        IColony colony;
        if (!this.level.isClientSide && (this.level.getGameTime() + (long)this.tickOffset) % 20L * 60L == 0L && (colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, (ResourceKey<Level>)this.level.dimension())) != null) {
            this.colonyNameCache = colony.getName();
            ColonyConnectionNode node = colony.getConnectionManager().getNode(this.getBlockPos());
            if (node != null) {
                this.calculateRotation(node.getPreviousNode());
                BlockPos previousNodePos = node.getPreviousNode();
                if (!previousNodePos.equals((Object)BlockPos.ZERO) && WorldUtil.isBlockLoaded((LevelAccessor)this.level, previousNodePos)) {
                    BlockEntity blockEntity = this.level.getBlockEntity(previousNodePos);
                    if (blockEntity instanceof TileEntityColonySign) {
                        TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity;
                        this.distance = (int)BlockPosUtil.dist(previousNodePos, this.getBlockPos()) + tileEntityColonySign.distance;
                    } else {
                        this.distance = (int)BlockPosUtil.dist(previousNodePos, this.getBlockPos());
                    }
                    this.setChanged();
                }
                this.targetColonyId = node.getTargetColonyId();
                if (this.targetColonyId != -1) {
                    IColony targetColony;
                    BlockPos nextNodePos = node.getNextNode();
                    if (!nextNodePos.equals((Object)BlockPos.ZERO) && WorldUtil.isBlockLoaded((LevelAccessor)this.level, nextNodePos)) {
                        BlockEntity blockEntity = this.level.getBlockEntity(nextNodePos);
                        if (blockEntity instanceof TileEntityColonySign) {
                            TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity;
                            this.targetColonyDistance = (int)BlockPosUtil.dist(nextNodePos, this.getBlockPos()) + tileEntityColonySign.targetColonyDistance;
                        } else {
                            this.targetColonyDistance = (int)BlockPosUtil.dist(nextNodePos, this.getBlockPos());
                        }
                        this.setChanged();
                    }
                    if ((targetColony = IColonyManager.getInstance().getColonyByDimension(this.targetColonyId, (ResourceKey<Level>)this.level.dimension())) != null) {
                        this.targetColonyNameCache = targetColony.getName();
                        this.setChanged();
                    }
                }
            }
            this.setChanged();
        }
    }

    private void calculateRotation(BlockPos previousNode) {
        double dx = (double)previousNode.getX() + 0.5 - ((double)this.getBlockPos().getX() + 0.5);
        double dz = (double)previousNode.getZ() + 0.5 - ((double)this.getBlockPos().getZ() + 0.5);
        double angleRad = Math.atan2(-dz, dx);
        float angleDeg = (float)Math.toDegrees(angleRad);
        this.rotation = (angleDeg + 360.0f) % 360.0f;
    }

    public void setColonyAndAnchor(IColony colony, @Nullable BlockPos anchor) {
        this.colonyId = colony.getID();
        this.anchor = anchor == null ? colony.getCenter() : anchor;
        this.distance = (int)BlockPosUtil.dist(colony.getCenter(), this.getBlockPos());
        this.colonyNameCache = colony.getName();
        this.calculateRotation(this.anchor);
    }

    public String getColonyName() {
        return this.colonyNameCache;
    }

    public float getRelativeRotation() {
        return this.rotation;
    }

    public int getColonyDistance() {
        return this.distance;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public int getTargetColonyId() {
        return this.targetColonyId;
    }

    public String getTargetColonyName() {
        return this.targetColonyNameCache;
    }

    public int getTargetColonyDistance() {
        return this.targetColonyDistance;
    }
}

