/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.parameters;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.CooldownHandler;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.core.parameters.IBonusParameterType;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.utils.MinecraftInstanceHelper;
import io.redspace.ironsjewelry.utils.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ActionParameter
implements IBonusParameterType<ActionRunnable> {
    public static final Codec<ActionRunnable> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IAction.CODEC.fieldOf("action").forGetter(ActionRunnable::action), (App)Codec.BOOL.fieldOf("targetSelf").forGetter(ActionRunnable::targetSelf)).apply((Applicative)builder, ActionRunnable::new));

    @Override
    public Codec<ActionRunnable> codec() {
        return CODEC;
    }

    @Override
    public Optional<String> getValueDescriptionId(ActionRunnable value) {
        ResourceLocation resource = IronsJewelryRegistries.ACTION_REGISTRY.getKey(value.action.codec());
        if (resource != null) {
            return Optional.of(String.format("action.%s.%s.name", resource.getNamespace(), resource.getPath()));
        }
        return Optional.empty();
    }

    public List<Component> getActionTooltip(String prefixDescriptionId, ActionRunnable param, BonusInstance bonusInstance) {
        MutableComponent desc = Component.literal((String)" ").append((Component)Component.translatable((String)prefixDescriptionId, (Object[])new Object[]{param.action.formatTooltip(bonusInstance, param.targetSelf())})).withStyle(ChatFormatting.YELLOW);
        Optional<Component> cooldown = this.getCooldownDescriptor(bonusInstance, param);
        return cooldown.map(component -> List.of(desc, Component.literal((String)" ").append(component))).orElseGet(() -> List.of(desc));
    }

    public Optional<Component> getCooldownDescriptor(BonusInstance bonusInstance, ActionRunnable param) {
        int cooldown = bonusInstance.cooldown().map(c -> CooldownHandler.INSTANCE.getCooldown((LivingEntity)MinecraftInstanceHelper.getPlayer(), (QualityScalar)c, bonusInstance.quality())).orElse(0);
        if (cooldown > 0) {
            return Optional.of(Component.translatable((String)"tooltip.irons_jewelry.cooldown", (Object[])new Object[]{Component.literal((String)Utils.timeFromTicks(cooldown, 1)).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN));
        }
        return Optional.empty();
    }

    public record ActionRunnable(IAction action, boolean targetSelf) {
    }
}

