/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.utils;

import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class Trades {
    public static int calculatePatternPrice(ItemStack stack, RandomSource randomSource) {
        Holder heldPattern = (Holder)stack.get(ComponentRegistry.STORED_PATTERN);
        if (heldPattern != null) {
            PatternDefinition pattern = (PatternDefinition)heldPattern.value();
            return (int)((double)(randomSource.nextIntBetweenInclusive(15, 20) + pattern.partTemplate().size() * 2) * pattern.qualityMultiplier());
        }
        return 0;
    }

    public static int calculateJewelryPrice(ItemStack stack, RandomSource randomSource) {
        JewelryData jewelryData = (JewelryData)stack.get(ComponentRegistry.JEWELRY_COMPONENT);
        if (jewelryData != null && jewelryData.isValid()) {
            int cost = (int)(12.0 * ((PatternDefinition)jewelryData.pattern().value()).qualityMultiplier());
            for (Holder<MaterialDefinition> part : jewelryData.parts().values()) {
                cost += (int)(4.0 * ((MaterialDefinition)part.value()).quality());
            }
            if (((PatternDefinition)jewelryData.pattern().value()).partForQuality().isPresent()) {
                cost = (int)((double)cost * ((MaterialDefinition)jewelryData.parts().get(((PatternDefinition)jewelryData.pattern().value()).partForQuality().get()).value()).quality());
            }
            return cost;
        }
        return 0;
    }

    public record SellItemTag(TagKey<Item> itemTag, int maxUses, int villagerXp, float priceMultiplier, int emeraldValue) implements VillagerTrades.ItemListing
    {
        public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
            Level level = pTrader.level();
            if (level instanceof ServerLevel) {
                HolderSet.Named set;
                Optional item;
                ServerLevel serverLevel = (ServerLevel)level;
                Optional options = BuiltInRegistries.ITEM.getTag(this.itemTag);
                if (options.isPresent() && (item = (set = (HolderSet.Named)options.get()).getRandomElement(pRandom)).isPresent()) {
                    ItemStack stack = new ItemStack((Holder)item.get());
                    return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldValue), stack, this.maxUses, this.villagerXp, this.priceMultiplier);
                }
            }
            return null;
        }
    }

    public record BuyItemTag(TagKey<Item> itemTag, int buyCount, int emeraldCost, int maxUses, int villagerXp, float priceMultiplier) implements VillagerTrades.ItemListing
    {
        public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
            Level level = pTrader.level();
            if (level instanceof ServerLevel) {
                HolderSet.Named set;
                Optional item;
                ServerLevel serverLevel = (ServerLevel)level;
                Optional options = BuiltInRegistries.ITEM.getTag(this.itemTag);
                if (options.isPresent() && (item = (set = (HolderSet.Named)options.get()).getRandomElement(pRandom)).isPresent()) {
                    return new MerchantOffer(new ItemCost((ItemLike)((Holder)item.get()).value(), this.buyCount), new ItemStack((ItemLike)Items.EMERALD, this.emeraldCost), this.maxUses, this.villagerXp, this.priceMultiplier);
                }
            }
            return null;
        }
    }

    public record SellLootTable(ResourceKey<LootTable> lootTable, int maxUses, int villagerXp, float priceMultiplier, BiFunction<ItemStack, RandomSource, Integer> itemCostFunction) implements VillagerTrades.ItemListing
    {
        public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
            Level level = pTrader.level();
            if (level instanceof ServerLevel) {
                ItemCost primaryCost;
                LootParams context;
                ServerLevel serverLevel = (ServerLevel)level;
                LootTable loottable = serverLevel.getServer().reloadableRegistries().getLootTable(this.lootTable);
                ObjectArrayList items = loottable.getRandomItems(context = new LootParams.Builder(serverLevel).create(LootContextParamSets.EMPTY));
                if (items.isEmpty()) {
                    return null;
                }
                ItemStack stack = (ItemStack)items.getFirst();
                int price = this.itemCostFunction.apply(stack, pRandom);
                if (price == 0) {
                    return null;
                }
                Optional<Object> secondaryCost = Optional.empty();
                if (price > 576) {
                    primaryCost = new ItemCost((ItemLike)Items.EMERALD_BLOCK, 64);
                    if ((price -= 576) >= 9) {
                        secondaryCost = Optional.of(new ItemCost((ItemLike)Items.EMERALD_BLOCK, Math.max(1, price / 9)));
                    }
                } else if (price > 64) {
                    int blocks = price / 9;
                    primaryCost = new ItemCost((ItemLike)Items.EMERALD_BLOCK, blocks);
                    if ((price -= blocks * 9) > 0) {
                        secondaryCost = Optional.of(new ItemCost((ItemLike)Items.EMERALD, price % 9));
                    }
                } else {
                    primaryCost = new ItemCost((ItemLike)Items.EMERALD, price);
                }
                return new MerchantOffer(primaryCost, secondaryCost, stack, this.maxUses, this.villagerXp, this.priceMultiplier);
            }
            return null;
        }
    }

    public record BuyItem(Item toBuy, int toBuyCount, int emeraldCost, int maxUses, int villagerXp, float priceMultiplier) implements VillagerTrades.ItemListing
    {
        public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
            return new MerchantOffer(new ItemCost((ItemLike)this.toBuy, this.toBuyCount), new ItemStack((ItemLike)Items.EMERALD, this.emeraldCost), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

