/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ClientStorageCache {
    private final Int2ObjectOpenHashMap<List<ItemStack>> entriesByItemId = new Int2ObjectOpenHashMap();
    private List<ItemStack> stacks = new ArrayList<ItemStack>();
    private boolean entriesByItemIdNeedsUpdate = true;

    public List<ItemStack> stacks() {
        return this.stacks;
    }

    public void update(List<ItemStack> stacks) {
        this.stacks = stacks;
        this.entriesByItemIdNeedsUpdate = true;
    }

    public List<ItemStack> getByIngredient(Ingredient ingredient) {
        ArrayList<ItemStack> entries = new ArrayList<ItemStack>();
        for (int i = 0; i < ingredient.getStackingIds().size(); ++i) {
            int itemId = ingredient.getStackingIds().getInt(i);
            for (ItemStack entry : this.getByItemId(itemId)) {
                if (!ingredient.test(entry)) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    private Collection<ItemStack> getByItemId(int itemId) {
        if (this.entriesByItemIdNeedsUpdate) {
            this.rebuildItemIdToEntries();
            this.entriesByItemIdNeedsUpdate = false;
        }
        return (Collection)this.entriesByItemId.getOrDefault(itemId, List.of());
    }

    private void rebuildItemIdToEntries() {
        this.entriesByItemId.clear();
        for (ItemStack entry : this.stacks()) {
            int itemId = BuiltInRegistries.ITEM.getId((Object)entry.getItem());
            List currentList = (List)this.entriesByItemId.get(itemId);
            if (currentList == null) {
                this.entriesByItemId.put(itemId, List.of(entry));
                continue;
            }
            if (currentList.size() == 1) {
                ArrayList<ItemStack> mutableList = new ArrayList<ItemStack>(10);
                mutableList.addAll(currentList);
                mutableList.add(entry);
                this.entriesByItemId.put(itemId, mutableList);
                continue;
            }
            currentList.add(entry);
        }
    }
}

