/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.misc;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ClientPentacleManager {
    public static BlockPos lastHovered = null;
    public static List<MutableComponent> lastPentacles = List.of();
    public static List<MutableComponent> allPentacles = List.of();
    public static long lastPentacleQueryTime = 0L;
    public static long lastPageChangeTime = 0L;
    public static final int ITEMS_PER_PAGE = Occultism.CLIENT_CONFIG.misc.pentagramInBowlInfoCount.getAsInt();
    public static final int PAGE_CHANGE_TICKS = Occultism.CLIENT_CONFIG.misc.pentagramInBowlInfoTicks.getAsInt();
    public static MutableComponent noPentacleFound = Component.translatable((String)"hud.occultism.no_pentacle_found");
    private static int currentPage = 0;
    private static int totalPages = 0;
    public static MutableComponent pageIndicator = null;

    public static void reset() {
        lastHovered = null;
        lastPentacles = List.of();
        allPentacles = List.of();
        lastPentacleQueryTime = 0L;
        lastPageChangeTime = 0L;
        currentPage = 0;
        totalPages = 0;
        pageIndicator = null;
    }

    public static void rebuild(BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        if (!pos.equals((Object)lastHovered) || allPentacles.isEmpty()) {
            if (!allPentacles.isEmpty() || mc.level.getGameTime() - lastPentacleQueryTime >= 20L) {
                lastPentacleQueryTime = mc.level.getGameTime();
                lastHovered = pos;
                allPentacles = mc.level.getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> ((RitualRecipe)r.value()).getPentacle().validate((Level)mc.level, pos) != null).collect(Collectors.toMap(r -> ((RitualRecipe)r.value()).getPentacle().getId(), Function.identity(), (existing, replacement) -> existing)).values().stream().map(r -> Component.translatable((String)"hud.occultism.pentacle_found", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)((RitualRecipe)r.value()).getPentacle().getId())).withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.WHITE)})).collect(Collectors.toList());
                currentPage = 0;
                ClientPentacleManager.calculateTotalPages();
                ClientPentacleManager.updateDisplayedPentacles();
            }
        } else {
            long currentTime = mc.level.getGameTime();
            if (totalPages > 1 && currentTime - lastPageChangeTime >= (long)PAGE_CHANGE_TICKS) {
                lastPageChangeTime = currentTime;
                ClientPentacleManager.changePage();
            }
        }
    }

    private static void calculateTotalPages() {
        totalPages = (int)Math.ceil((double)allPentacles.size() / (double)ITEMS_PER_PAGE);
        if (totalPages == 0) {
            totalPages = 1;
        }
    }

    private static void changePage() {
        if (totalPages <= 1) {
            return;
        }
        currentPage = (currentPage + 1) % totalPages;
        ClientPentacleManager.updateDisplayedPentacles();
    }

    private static void updateDisplayedPentacles() {
        if (allPentacles.isEmpty()) {
            lastPentacles = List.of();
            pageIndicator = null;
            return;
        }
        int startIdx = currentPage * ITEMS_PER_PAGE;
        int endIdx = Math.min(startIdx + ITEMS_PER_PAGE, allPentacles.size());
        pageIndicator = totalPages > 1 ? Component.literal((String)"Page ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(currentPage + 1)).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(totalPages)).withStyle(ChatFormatting.YELLOW)) : null;
        ArrayList<MutableComponent> displayedPentacles = new ArrayList<MutableComponent>();
        if (startIdx < allPentacles.size()) {
            MutableComponent firstItem = allPentacles.get(startIdx).copy();
            displayedPentacles.add(firstItem);
        }
        for (int i = startIdx + 1; i < endIdx; ++i) {
            displayedPentacles.add(allPentacles.get(i).copy());
        }
        if (totalPages > 1 && pageIndicator != null) {
            displayedPentacles.add(pageIndicator);
        }
        lastPentacles = displayedPentacles;
    }
}

