/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.client.render.OccultismRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class SelectedBlockRenderer {
    protected Set<SelectionInfo> selectedBlocks = new HashSet<SelectionInfo>();

    public void selectBlock(BlockPos pos, long expireTime) {
        this.selectBlock(pos, expireTime, new Color(1.0f, 1.0f, 1.0f, 0.8f));
    }

    public void selectBlock(BlockPos pos, long expireTime, Color color) {
        SelectionInfo info = new SelectionInfo(this, pos, expireTime, color);
        this.selectedBlocks.remove(info);
        this.selectedBlocks.add(info);
    }

    public void unselectBlock(BlockPos pos) {
        this.selectedBlocks.removeIf(info -> info.selectedBlock.equals((Object)pos));
    }

    @SubscribeEvent
    public void RenderLevelLastEvent(RenderLevelStageEvent event) {
        this.renderSelectedBlocks(event);
    }

    protected void renderSelectedBlocks(RenderLevelStageEvent event) {
        Boolean useAltRenderer = (Boolean)Occultism.CLIENT_CONFIG.visuals.useAlternativeDivinationRodRenderer.get();
        if (!useAltRenderer.booleanValue() && event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (useAltRenderer.booleanValue() && event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!this.selectedBlocks.isEmpty()) {
            long time = System.currentTimeMillis();
            PoseStack matrixStack = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderType renderType = useAltRenderer != false ? OccultismRenderType.overlayLinesAlternative() : OccultismRenderType.overlayLines();
            VertexConsumer builder = buffer.getBuffer(renderType);
            matrixStack.pushPose();
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Vec3 cameraPosition = camera.getPosition();
            matrixStack.translate(-cameraPosition.x, -cameraPosition.y, -cameraPosition.z);
            Iterator<SelectionInfo> it = this.selectedBlocks.iterator();
            while (it.hasNext()) {
                SelectionInfo info = it.next();
                if (time > info.selectionExpireTime || info.selectedBlock == null) {
                    it.remove();
                    continue;
                }
                LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)builder, (double)info.selectedBlock.getX(), (double)info.selectedBlock.getY(), (double)info.selectedBlock.getZ(), (double)(info.selectedBlock.getX() + 1), (double)(info.selectedBlock.getY() + 1), (double)(info.selectedBlock.getZ() + 1), (float)((float)info.color.getRed() / 255.0f), (float)((float)info.color.getGreen() / 255.0f), (float)((float)info.color.getBlue() / 255.0f), (float)((float)info.color.getAlpha() / 255.0f));
            }
            matrixStack.popPose();
            RenderSystem.disableDepthTest();
            buffer.endBatch();
        }
    }

    public class SelectionInfo {
        public BlockPos selectedBlock;
        public long selectionExpireTime;
        public Color color;

        public SelectionInfo(SelectedBlockRenderer this$0, BlockPos selectedBlock, long selectionExpireTime, Color color) {
            this.selectedBlock = selectedBlock;
            this.selectionExpireTime = selectionExpireTime;
            this.color = color;
        }

        public int hashCode() {
            return this.selectedBlock.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            SelectionInfo other = (SelectionInfo)obj;
            if (other == null) {
                return false;
            }
            return other.selectedBlock.equals((Object)this.selectedBlock);
        }
    }
}

