/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container;

import com.klikli_dev.occultism.common.blockentity.DimensionalMineshaftBlockEntity;
import com.klikli_dev.occultism.registry.OccultismContainers;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.util.RecipeUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class DimensionalMineshaftContainer
extends AbstractContainerMenu {
    public ItemStackHandler inputHandler;
    public ItemStackHandler outputHandler;
    public DimensionalMineshaftBlockEntity otherworldMiner;
    public Inventory playerInventory;

    public DimensionalMineshaftContainer(int id, Inventory playerInventory, DimensionalMineshaftBlockEntity otherworldMiner) {
        super(OccultismContainers.OTHERWORLD_MINER.get(), id);
        this.playerInventory = playerInventory;
        this.otherworldMiner = otherworldMiner;
        this.inputHandler = otherworldMiner.inputHandler;
        this.outputHandler = otherworldMiner.outputHandler;
        this.setupMinerInventory();
        this.setupPlayerInventorySlots(playerInventory.player);
        this.setupPlayerHotbar(playerInventory.player);
    }

    public boolean stillValid(Player player) {
        return player.distanceToSqr((double)this.otherworldMiner.getBlockPos().getX() + 0.5, (double)this.otherworldMiner.getBlockPos().getY() + 0.5, (double)this.otherworldMiner.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.outputHandler.getSlots() ? !this.moveItemStackTo(itemstack1, this.outputHandler.getSlots() + 1, this.slots.size(), true) : (index == this.outputHandler.getSlots() ? !this.moveItemStackTo(itemstack1, this.outputHandler.getSlots() + 1, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.outputHandler.getSlots() + 1, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    protected void setupPlayerInventorySlots(Player player) {
        int playerInventoryTop = 84;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar(Player player) {
        int hotbarTop = 142;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)player.getInventory(), i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupMinerInventory() {
        int outputGridTop = 17;
        int outputGridLeft = 98;
        int index = 0;
        ItemStackHandler outputHandler = this.otherworldMiner.outputHandler;
        ItemStackHandler inputHandler = this.otherworldMiner.inputHandler;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot((Slot)new OutputSlot(this, (IItemHandler)outputHandler, index++, outputGridLeft + j * 18, outputGridTop + i * 18));
            }
        }
        this.addSlot((Slot)new InputSlot((IItemHandler)inputHandler, 0, 26, 35));
    }

    public class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(DimensionalMineshaftContainer this$0, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }

    public class InputSlot
    extends SlotItemHandler {
        public InputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            RecipeManager recipeManager = DimensionalMineshaftContainer.this.otherworldMiner.getLevel().getRecipeManager();
            return RecipeUtil.isValidIngredient(recipeManager, (RecipeType)OccultismRecipes.MINER_TYPE.get(), stack);
        }
    }
}

