/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit.demonicpartner;

import com.klikli_dev.occultism.common.entity.spirit.demonicpartner.DemonicPartner;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class DemonicPartnerLieNextToPartnerGoal
extends Goal {
    private final DemonicPartner entity;
    @Nullable
    private Player ownerPlayer;
    @Nullable
    private BlockPos goalPos;

    public DemonicPartnerLieNextToPartnerGoal(DemonicPartner pCat) {
        this.entity = pCat;
    }

    public boolean canUse() {
        if (!this.entity.isTame()) {
            return false;
        }
        if (this.entity.isOrderedToSit()) {
            return false;
        }
        LivingEntity livingentity = this.entity.getOwner();
        if (livingentity instanceof Player) {
            this.ownerPlayer = (Player)livingentity;
            if (!livingentity.isSleeping()) {
                return false;
            }
            if (this.entity.distanceToSqr((Entity)this.ownerPlayer) > 100.0) {
                return false;
            }
            BlockPos blockpos = this.ownerPlayer.blockPosition();
            BlockState blockstate = this.entity.level().getBlockState(blockpos);
            if (blockstate.is(BlockTags.BEDS)) {
                Direction facing = (Direction)blockstate.getValue((Property)BedBlock.FACING);
                BlockPos leftPos = blockpos.relative(facing.getClockWise());
                BlockPos rightPos = blockpos.relative(facing.getCounterClockWise());
                BlockState leftState = this.entity.level().getBlockState(leftPos);
                BlockState rightState = this.entity.level().getBlockState(rightPos);
                if (leftState.is(BlockTags.BEDS) && leftState.getValue((Property)BedBlock.FACING) == facing) {
                    this.goalPos = this.getHeadPos(leftPos, leftState, facing);
                } else if (rightState.is(BlockTags.BEDS) && rightState.getValue((Property)BedBlock.FACING) == facing) {
                    this.goalPos = this.getHeadPos(rightPos, rightState, facing);
                }
                return this.goalPos != null && !this.spaceIsOccupied();
            }
        }
        return false;
    }

    private BlockPos getHeadPos(BlockPos pos, BlockState state, Direction facing) {
        if (state.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
            return pos.relative(facing);
        }
        return pos;
    }

    private boolean spaceIsOccupied() {
        for (DemonicPartner partner : this.entity.level().getEntitiesOfClass(DemonicPartner.class, new AABB(this.goalPos).inflate(2.0))) {
            if (partner == this.entity || !partner.isLying()) continue;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.entity.isTame() && !this.entity.isOrderedToSit() && this.ownerPlayer != null && this.ownerPlayer.isSleeping() && this.goalPos != null && !this.spaceIsOccupied();
    }

    public void start() {
        if (this.goalPos != null) {
            this.entity.setInSittingPose(false);
            this.entity.getNavigation().moveTo((double)this.goalPos.getX(), (double)this.goalPos.getY(), (double)this.goalPos.getZ(), (double)1.1f);
        }
    }

    public void stop() {
        this.entity.stopSleeping();
        this.entity.setLying(false);
        float f = this.entity.level().getTimeOfDay(1.0f);
        if (this.ownerPlayer.getSleepTimer() < 100 || !((double)f > 0.77) || !((double)f < 0.8) || (double)this.entity.level().getRandom().nextFloat() < 0.7) {
            // empty if block
        }
        this.entity.getNavigation().stop();
    }

    private void giveMorningGift() {
        RandomSource randomsource = this.entity.getRandom();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.set((Vec3i)(this.entity.isLeashed() ? this.entity.getLeashHolder().blockPosition() : this.entity.blockPosition()));
        this.entity.randomTeleport(blockpos$mutableblockpos.getX() + randomsource.nextInt(11) - 5, blockpos$mutableblockpos.getY() + randomsource.nextInt(5) - 2, blockpos$mutableblockpos.getZ() + randomsource.nextInt(11) - 5, false);
        blockpos$mutableblockpos.set((Vec3i)this.entity.blockPosition());
        LootTable loottable = this.entity.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.CAT_MORNING_GIFT);
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.entity.level()).withParameter(LootContextParams.ORIGIN, (Object)this.entity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.entity).create(LootContextParamSets.GIFT);
        for (ItemStack itemstack : loottable.getRandomItems(lootparams)) {
            this.entity.level().addFreshEntity((Entity)new ItemEntity(this.entity.level(), (double)blockpos$mutableblockpos.getX() - (double)Mth.sin((float)(this.entity.yBodyRot * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.getY(), (double)blockpos$mutableblockpos.getZ() + (double)Mth.cos((float)(this.entity.yBodyRot * ((float)Math.PI / 180))), itemstack));
        }
    }

    public void tick() {
        if (this.ownerPlayer != null && this.goalPos != null) {
            this.entity.setInSittingPose(false);
            this.entity.getNavigation().moveTo((double)this.goalPos.getX(), (double)this.goalPos.getY(), (double)this.goalPos.getZ(), (double)1.1f);
            if (this.entity.distanceToSqr((Entity)this.ownerPlayer) < 2.5) {
                this.entity.startSleeping(this.goalPos);
                this.entity.setLying(true);
            } else {
                this.entity.setLying(false);
            }
        }
    }
}

