/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit.calling;

import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;

public class SetManagedMachineMode
extends ItemMode {
    public SetManagedMachineMode() {
        super("set_managed_machine");
    }

    public boolean setSpiritManagedMachine(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.getServer(), boundSpiritId).map(e -> (SpiritEntity)e);
            BlockEntity managedMachineBlockEntity = world.getBlockEntity(pos);
            if (boundSpirit.isPresent() && managedMachineBlockEntity != null) {
                SpiritJob spiritJob;
                if (boundSpirit.get().getJob().isPresent() && (spiritJob = boundSpirit.get().getJob().get()) instanceof ManageMachineJob) {
                    ManageMachineJob manageMachine = (ManageMachineJob)spiritJob;
                    MachineReference newReference = MachineReference.from(managedMachineBlockEntity, managedMachineBlockEntity);
                    if (manageMachine.getManagedMachine() == null || !manageMachine.getManagedMachine().insertGlobalPos.equals(newReference.insertGlobalPos)) {
                        manageMachine.setManagedMachine(newReference);
                    } else {
                        manageMachine.getManagedMachine().insertRegistryName = newReference.insertRegistryName;
                    }
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_managed_machine", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().getName().getString())}), true);
                    return true;
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    @Override
    public boolean handle(BlockEntity blockEntity, Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        if (blockEntity != null && BlockEntityUtil.hasCapabilityOnAnySide(blockEntity, Capabilities.ItemHandler.BLOCK)) {
            this.setSpiritManagedMachine(player, world, pos, stack, face);
            return true;
        }
        return true;
    }
}

