/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class UpgradeRitual
extends Ritual {
    public UpgradeRitual(RitualRecipe recipe) {
        super(recipe);
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        super.finish(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem);
        ItemStack copy = activationItem.copy();
        activationItem.shrink(1);
        ItemStack base = blockEntity.consumedIngredients.getFirst().copy();
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.5, (double)goldenBowlPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        ItemStack result = this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
        Rarity rarity = result.getRarity();
        result.applyComponents(base.getComponents());
        if (result.has(DataComponents.MAX_DAMAGE)) {
            int maxDurability = result.getMaxDamage();
            result.applyComponents(DataComponentMap.builder().set(DataComponents.MAX_DAMAGE, (Object)maxDurability).build());
        }
        if (copy.has(OccultismDataComponents.SPIRIT_NAME)) {
            ItemNBTUtil.setBoundSpiritName(result, ItemNBTUtil.getBoundSpiritName(copy));
        }
        result.applyComponents(DataComponentMap.builder().set(DataComponents.RARITY, (Object)rarity).build());
        this.dropResult(level, goldenBowlPosition, blockEntity, (Player)castingPlayer, result, true);
    }
}

