/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe.conditionextension;

import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionVisitor;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionWrapperFactory;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.OccultismConditionContext;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInBiomeCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInBiomeWithTagCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInDimensionCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.condition.IsInDimensionTypeCondition;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.AndConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.FalseConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.ItemExistsConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.ModLoadedConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.NotConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.OrConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.TagEmptyConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.wrapper.TrueConditionWrapper;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public class RitualRecipeConditionDescriptionVisitor
implements ConditionVisitor {
    @Override
    public MutableComponent visit(AndConditionWrapper condition, OccultismConditionContext context) {
        MutableComponent contained = Component.empty();
        List children = condition.condition().children();
        for (int i = 0; i < children.size(); ++i) {
            MutableComponent c = ConditionWrapperFactory.wrap((ICondition)children.get(i)).accept(this, context);
            if (i == 0) {
                contained.append("\n\n").append("(").append((Component)c).append(")");
                continue;
            }
            contained.append("\n AND \n").append("(").append((Component)c).append(")");
        }
        return Component.translatable((String)"condition.occultism.ritual.and.description", (Object[])new Object[]{contained});
    }

    @Override
    public MutableComponent visit(OrConditionWrapper condition, OccultismConditionContext context) {
        MutableComponent contained = Component.empty();
        List children = condition.condition().values();
        for (int i = 0; i < children.size(); ++i) {
            MutableComponent c = ConditionWrapperFactory.wrap((ICondition)children.get(i)).accept(this, context);
            if (i == 0) {
                contained.append("\n\n").append("(").append((Component)c).append(")");
                continue;
            }
            contained.append("\n OR \n").append("(").append((Component)c).append(")");
        }
        return Component.translatable((String)"condition.occultism.ritual.or.description", (Object[])new Object[]{contained});
    }

    @Override
    public MutableComponent visit(TrueConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.true.description");
    }

    @Override
    public MutableComponent visit(FalseConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.false.description");
    }

    @Override
    public MutableComponent visit(NotConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.not.description", (Object[])new Object[]{ConditionWrapperFactory.wrap(condition.condition().value()).accept(this, context)});
    }

    @Override
    public MutableComponent visit(ItemExistsConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.item_exists.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)condition.condition().getItem()))});
    }

    @Override
    public MutableComponent visit(ModLoadedConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.mod_loaded.description", (Object[])new Object[]{condition.condition().modid()});
    }

    @Override
    public MutableComponent visit(TagEmptyConditionWrapper condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.tag_empty.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"tag", (ResourceLocation)condition.condition().tag().location()))});
    }

    @Override
    public MutableComponent visit(IsInBiomeCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_biome.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)((ResourceKey)condition.biome().unwrapKey().orElseThrow()).location()))});
    }

    @Override
    public MutableComponent visit(IsInBiomeWithTagCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_biome_with_tag.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"tag", (ResourceLocation)condition.tag().location()))});
    }

    @Override
    public MutableComponent visit(IsInDimensionCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_dimension.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)condition.dimension().location()))});
    }

    @Override
    public MutableComponent visit(IsInDimensionTypeCondition condition, OccultismConditionContext context) {
        return Component.translatable((String)"condition.occultism.ritual.is_in_dimension_type.description", (Object[])new Object[]{Component.translatable((String)Util.makeDescriptionId((String)"dimension_type", (ResourceLocation)((ResourceKey)condition.dimensionType().unwrapKey().orElseThrow()).location()))});
    }
}

