/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe.builders;

import com.klikli_dev.occultism.crafting.recipe.CrystallizeRecipe;
import com.klikli_dev.occultism.crafting.recipe.result.RecipeResult;
import com.klikli_dev.occultism.crafting.recipe.result.TagRecipeResult;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrystallizeRecipeBuilder
implements RecipeBuilder {
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private final RecipeSerializer<CrystallizeRecipe> serializer = (RecipeSerializer)OccultismRecipes.CRYSTALLIZE.get();
    private final Ingredient ingredient;
    private final int crystallizeTime;
    private RecipeResult result;
    @Nullable
    private String group;
    private boolean ignoreCrystallizeMultiplier;
    private int minTier;
    private int maxTier;
    private boolean allowEmpty;

    public CrystallizeRecipeBuilder(Ingredient ingredient, RecipeResult result, int crystallizeTime) {
        this.ingredient = ingredient;
        this.allowEmpty = false;
        this.crystallizeTime = crystallizeTime;
        this.result = result;
        this.minTier = -1;
        this.maxTier = -1;
    }

    public static CrystallizeRecipeBuilder crystallizeRecipe(TagKey<Item> ingredient, ItemLike result, int crystallizeTime) {
        return CrystallizeRecipeBuilder.crystallizeRecipe(Ingredient.of(ingredient), result, crystallizeTime);
    }

    public static CrystallizeRecipeBuilder crystallizeRecipe(Ingredient ingredient, ItemLike result, int crystallizeTime) {
        return new CrystallizeRecipeBuilder(ingredient, RecipeResult.of(new ItemStack(result)), crystallizeTime);
    }

    public static CrystallizeRecipeBuilder crystallizeRecipe(Item item, TagKey<Item> result, int crystallizeTime) {
        return new CrystallizeRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{item}), TagRecipeResult.of(result), crystallizeTime);
    }

    public static CrystallizeRecipeBuilder crystallizeRecipe(Item item, ItemLike result, int crystallizeTime) {
        return new CrystallizeRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{item}), RecipeResult.of(new ItemStack(result)), crystallizeTime);
    }

    public static CrystallizeRecipeBuilder crystallizeRecipe(TagKey<Item> ingredient, TagKey<Item> result, int crystallizeTime) {
        return new CrystallizeRecipeBuilder(Ingredient.of(ingredient), TagRecipeResult.of(result), crystallizeTime);
    }

    @NotNull
    public CrystallizeRecipeBuilder unlockedBy(@NotNull String s, @NotNull Criterion<?> criterionTriggerInstance) {
        this.criteria.put(s, criterionTriggerInstance);
        return this;
    }

    @NotNull
    public CrystallizeRecipeBuilder group(@Nullable String s) {
        this.group = s;
        return this;
    }

    @NotNull
    public Item getResult() {
        if (this.result.getStacks().length == 1) {
            return this.result.getStack().getItem();
        }
        return Items.AIR;
    }

    public CrystallizeRecipeBuilder allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public CrystallizeRecipeBuilder setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public CrystallizeRecipeBuilder setResultAmount(int outputAmount) {
        this.result = this.result.copyWithCount(outputAmount);
        return this;
    }

    public int getCrystallizeTime() {
        return this.crystallizeTime;
    }

    public int getMinTier() {
        return this.minTier;
    }

    public CrystallizeRecipeBuilder setMinTier(int minTier) {
        this.minTier = minTier;
        return this;
    }

    public int getMaxTier() {
        return this.maxTier;
    }

    public CrystallizeRecipeBuilder setMaxTier(int maxTier) {
        this.maxTier = maxTier;
        return this;
    }

    public boolean getIgnoreCrystallizeMultiplier() {
        return this.ignoreCrystallizeMultiplier;
    }

    public CrystallizeRecipeBuilder setIgnoreCrystallizeMultiplier(boolean ignoreCrystallizeMultiplier) {
        this.ignoreCrystallizeMultiplier = ignoreCrystallizeMultiplier;
        return this;
    }

    public void save(@NotNull RecipeOutput pRecipeOutput, @NotNull ResourceLocation pId) {
        this.ensureValid(pId);
        Advancement.Builder advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ICondition[] conditions = this.getConditions(this.allowEmpty, this.ingredient, this.result);
        CrystallizeRecipe recipe = new CrystallizeRecipe(this.ingredient, this.result, this.minTier, this.maxTier, this.crystallizeTime, this.ignoreCrystallizeMultiplier);
        pRecipeOutput.accept(pId, (Recipe)recipe, advancement$builder.build(pId.withPrefix("recipes/crystallize/")), conditions);
    }

    protected ICondition[] getConditions(boolean allowEmpty, Ingredient ingredient, RecipeResult result) {
        ArrayList<ICondition> conditions = new ArrayList<ICondition>();
        if (!allowEmpty) {
            ICondition notCondition = this.getNoTagCondition(ingredient);
            if (notCondition != null) {
                conditions.add(notCondition);
            }
            if ((notCondition = this.getNoTagCondition(result)) != null) {
                conditions.add(notCondition);
            }
        }
        return conditions.toArray(new ICondition[0]);
    }

    protected ICondition getNoTagCondition(Ingredient ingredient) {
        Ingredient.Value value;
        if (ingredient.getValues().length == 1 && (value = ingredient.getValues()[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            return new NotCondition((ICondition)new TagEmptyCondition(tagValue.tag()));
        }
        return null;
    }

    protected ICondition getNoTagCondition(RecipeResult result) {
        if (result instanceof TagRecipeResult) {
            TagRecipeResult tagResult = (TagRecipeResult)result;
            return new NotCondition((ICondition)new TagEmptyCondition(tagResult.tag()));
        }
        return null;
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }
}

