/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.rules.TestingTools;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class EventsConditions {
    private final Set<ResourceKey<Level>> dimensions;
    private final float random;
    private final Set<String> phases;
    private final Map<String, Predicate<Integer>> numbers;
    public static final EventsConditions DEFAULT = EventsConditions.create().build();
    private static final Map<String, Cmd> CONDITIONS = new HashMap<String, Cmd>();

    private EventsConditions(Builder builder) {
        this.dimensions = new HashSet<ResourceKey<Level>>(builder.dimensions);
        this.random = builder.random;
        this.phases = builder.phases;
        this.numbers = builder.numbers;
    }

    public void validate() {
    }

    public Set<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }

    public float getRandom() {
        return this.random;
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public Map<String, Predicate<Integer>> getNumbers() {
        return this.numbers;
    }

    public static Builder create() {
        return new Builder();
    }

    public static void parse(JsonObject object, Builder builder) {
        block6: for (String attr : object.keySet()) {
            Cmd cmd = CONDITIONS.get(attr);
            if (cmd == null) {
                ErrorHandler.error("Invalid condition '" + attr + "' for spawner rule!");
                return;
            }
            switch (cmd.ordinal()) {
                case 0: {
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)element.getAsString()));
                            builder.dimensions(key);
                        }
                        continue block6;
                    }
                    Iterator key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)value.getAsString()));
                    builder.dimensions(new ResourceKey[]{key});
                    break;
                }
                case 1: {
                    builder.random(object.get(attr).getAsFloat());
                    break;
                }
                case 2: {
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            builder.phase(element.getAsString());
                        }
                        continue block6;
                    }
                    builder.phase(value.getAsString());
                    break;
                }
                case 3: {
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            TestingTools.NumberResult result = TestingTools.parseNumberCheck(element);
                            if (result == null) continue;
                            builder.numbers.put(result.number(), result.test());
                        }
                        continue block6;
                    }
                    TestingTools.NumberResult result = TestingTools.parseNumberCheck(value);
                    if (result == null) break;
                    builder.numbers.put(result.number(), result.test());
                }
            }
        }
    }

    static {
        for (Cmd cmd : Cmd.values()) {
            CONDITIONS.put(cmd.name().toLowerCase(), cmd);
        }
    }

    public static class Builder {
        private final Set<ResourceKey<Level>> dimensions = new HashSet<ResourceKey<Level>>();
        private float random = -1.0f;
        private final Set<String> phases = new HashSet<String>();
        private final Map<String, Predicate<Integer>> numbers = new HashMap<String, Predicate<Integer>>();

        public Builder dimensions(ResourceKey<Level> ... dimensions) {
            Collections.addAll(this.dimensions, dimensions);
            return this;
        }

        public Builder random(float random) {
            this.random = random;
            return this;
        }

        public Builder phase(String ... phases) {
            Collections.addAll(this.phases, phases);
            return this;
        }

        public Builder number(String name, Predicate<Integer> predicate) {
            this.numbers.put(name, predicate);
            return this;
        }

        public EventsConditions build() {
            return new EventsConditions(this);
        }
    }

    static enum Cmd {
        DIMENSION,
        RANDOM,
        PHASE,
        NUMBER;

    }
}

