/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record VineDecoration(float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos pos, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
        boolean ew = piece.rotation == Rotation.NONE || piece.rotation == Rotation.CLOCKWISE_180;
        int maxX = ew ? model.width : model.length;
        int maxZ = ew ? model.length : model.width;
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < maxZ; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
                    if (!worldGenBounds.isInside((Vec3i)currentPos) || !structureBounds.isInside((Vec3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.isEmptyBlock(currentPos)) continue;
                    BlockPos north = currentPos.north();
                    BlockPos east = currentPos.east();
                    BlockPos south = currentPos.south();
                    BlockPos west = currentPos.west();
                    BlockPos up = currentPos.above();
                    boolean _north = worldGenBounds.isInside((Vec3i)north) && structureBounds.isInside((Vec3i)north) && VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)north, (Direction)Direction.NORTH);
                    boolean _east = worldGenBounds.isInside((Vec3i)east) && structureBounds.isInside((Vec3i)east) && VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)east, (Direction)Direction.EAST);
                    boolean _south = worldGenBounds.isInside((Vec3i)south) && structureBounds.isInside((Vec3i)south) && VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)south, (Direction)Direction.SOUTH);
                    boolean _west = worldGenBounds.isInside((Vec3i)west) && structureBounds.isInside((Vec3i)west) && VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)west, (Direction)Direction.WEST);
                    boolean bl = _up = worldGenBounds.isInside((Vec3i)up) && structureBounds.isInside((Vec3i)up) && VineBlock.isAcceptableNeighbour((BlockGetter)world, (BlockPos)up, (Direction)Direction.UP);
                    if (!_north && !_east && !_south && !_west && !_up || !(random.nextFloat() < this.chance)) continue;
                    world.setBlock(currentPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.VINE.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(_north))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(_east))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(_south))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(_west))).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(_up)), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "vines");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        return object;
    }
}

